/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.locator;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.artifact.Gav;
import org.sonatype.nexus.artifact.GavCalculator;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.locator.GavHelpedLocator;

public class ArtifactLocator
implements GavHelpedLocator {
    private IndexingContext context = null;

    public ArtifactLocator(IndexingContext context) {
        this.context = context;
    }

    public File locate(File source, GavCalculator gavCalculator, Gav gav) {
        if (this.context != null) {
            ArtifactInfo ai = new ArtifactInfo(null, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), gav.getClassifier());
            Term term = new Term("u", ai.getUinfo());
            try {
                Document doc;
                TopDocs topdocs = this.context.getIndexSearcher().search((Query)new TermQuery(term), null, 1);
                if (topdocs != null && topdocs.scoreDocs != null && topdocs.scoreDocs.length > 0 && (doc = this.context.getIndexReader().document(topdocs.scoreDocs[0].doc)) != null) {
                    for (IndexCreator indexCreator : this.context.getIndexCreators()) {
                        indexCreator.updateArtifactInfo(doc, ai);
                    }
                    if (!(StringUtils.isEmpty((String)ai.artifactId) || StringUtils.isEmpty((String)ai.version) || StringUtils.isEmpty((String)ai.fextension))) {
                        return new File(source.getParentFile(), ai.artifactId + "-" + ai.version + (StringUtils.isEmpty((String)ai.classifier) ? "" : "-" + ai.classifier) + "." + ai.fextension);
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }
}

