/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.artifact;

import java.util.regex.Pattern;
import org.sonatype.nexus.artifact.DefaultNexusEnforcer;
import org.sonatype.nexus.artifact.NexusEnforcer;

public class VersionUtils {
    public static String SNAPSHOT_VERSION = "SNAPSHOT";
    private static NexusEnforcer enforcer = new DefaultNexusEnforcer();
    private static final Pattern VERSION_FILE_PATTERN = Pattern.compile("^(.*)-([0-9]{8}.[0-9]{6})-([0-9]+)$|^([0-9]{8}.[0-9]{6})-([0-9]+)$");
    private static final Pattern STRICT_VERSION_FILE_PATTERN = Pattern.compile("^(.*)-([0-9]{8}.[0-9]{6})-([0-9]+)$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSnapshot(String baseVersion) {
        if (enforcer.isStrict()) {
            Pattern pattern = STRICT_VERSION_FILE_PATTERN;
            synchronized (pattern) {
                return STRICT_VERSION_FILE_PATTERN.matcher(baseVersion).matches() || baseVersion.endsWith(SNAPSHOT_VERSION);
            }
        }
        Pattern pattern = VERSION_FILE_PATTERN;
        synchronized (pattern) {
            return VERSION_FILE_PATTERN.matcher(baseVersion).matches() || baseVersion.endsWith(SNAPSHOT_VERSION);
        }
    }
}

