/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;

public class EclipseModuleManager {
    private CachedXmlDocumentSet myDocumentSet;
    private Map<String, String> myEclipseVariablePaths = new HashMap<String, String>();
    private Set<String> myUnknownCons = new HashSet<String>();
    private boolean myForceConfigureJDK = false;
    private static final String SRC_PREFIX = "src:";
    private static final String SRC_LINK_PREFIX = "linksrc:";

    public EclipseModuleManager(Module module) {
    }

    public static EclipseModuleManager getInstance(Module module) {
        return (EclipseModuleManager)ModuleServiceManager.getService((Module)module, EclipseModuleManager.class);
    }

    public CachedXmlDocumentSet getDocumentSet() {
        return this.myDocumentSet;
    }

    public void setDocumentSet(CachedXmlDocumentSet documentSet) {
        this.myDocumentSet = documentSet;
    }

    public void registerEclipseVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(path, var);
    }

    public void registerEclipseSrcVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_PREFIX + path, var);
    }

    public void registerEclipseLinkedSrcVarPath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_LINK_PREFIX + path, var);
    }

    public String getEclipseLinkedSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_LINK_PREFIX + path);
    }

    public String getEclipseVariablePath(String path) {
        return this.myEclipseVariablePaths.get(path);
    }

    public String getEclipseSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_PREFIX + path);
    }

    public void registerUnknownCons(String con) {
        this.myUnknownCons.add(con);
    }

    public Set<String> getUnknownCons() {
        return this.myUnknownCons;
    }

    public boolean isForceConfigureJDK() {
        return this.myForceConfigureJDK;
    }

    public void setForceConfigureJDK() {
        this.myForceConfigureJDK = true;
    }
}

