/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.FileSet;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedXmlDocumentSet
implements FileSet {
    protected final Map<String, String> nameToDir = new HashMap();
    protected final Map<String, Document> savedContent = new HashMap();
    protected final Map<String, Document> modifiedContent = new HashMap();
    protected final Set<String> deletedContent = new HashSet<String>();
    private final Project project;

    public CachedXmlDocumentSet(Project project) {
        this.project = project;
    }

    public Document read(String name) throws IOException, JDOMException {
        return (Document)this.load(name).clone();
    }

    public void write(Document document, String name) throws IOException {
        this.update((Document)document.clone(), name);
    }

    public String getParent(String name) {
        return this.nameToDir.get(name);
    }

    public void register(String name, String path) {
        this.nameToDir.put(name, path);
    }

    protected void assertKnownName(String name) {
        assert (this.nameToDir.containsKey(name)) : name;
    }

    public boolean exists(String name) {
        this.assertKnownName(name);
        return !this.deletedContent.contains(name) && this.getVFile(name) != null;
    }

    @Nullable
    protected VirtualFile getVFile(String name) {
        return LocalFileSystem.getInstance().findFileByIoFile(new File(this.getParent(name), name));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private VirtualFile getOrCreateVFile(final String name) throws IOException {
        VirtualFile virtualFile;
        VirtualFile vFile = this.getVFile(name);
        if (vFile != null) {
            virtualFile = vFile;
            if (virtualFile == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet.getOrCreateVFile must not return null");
            return virtualFile;
        }
        final VirtualFile vDir = LocalFileSystem.getInstance().findFileByIoFile(new File(this.getParent(name)));
        if (vDir == null) {
            throw new IOException(name + ": file not found");
        }
        final IOException[] ex = new IOException[1];
        VirtualFile file = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    return vDir.createChildData((Object)this, name);
                }
                catch (IOException e) {
                    ex[0] = e;
                    return null;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        virtualFile = file;
        if (virtualFile != null) return virtualFile;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet.getOrCreateVFile must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document load(String name) throws IOException, JDOMException {
        this.assertKnownName(name);
        Document logical = this.modifiedContent.get(name);
        if (logical != null) {
            return logical;
        }
        Document physical = this.savedContent.get(name);
        if (physical == null) {
            VirtualFile vFile;
            VirtualFile virtualFile = vFile = this.deletedContent.contains(name) ? null : this.getVFile(name);
            if (vFile == null) {
                throw new IOException(name + ": file does not exist");
            }
            InputStream is = vFile.getInputStream();
            try {
                physical = JDOMUtil.loadDocument((InputStream)is);
            }
            finally {
                is.close();
            }
            this.savedContent.put(name, physical);
        }
        return physical;
    }

    public void preload() {
        for (String key : this.nameToDir.keySet()) {
            try {
                this.load(key);
            }
            catch (IOException ignore) {
            }
            catch (JDOMException jDOMException) {}
        }
    }

    public void update(Document content, String name) {
        this.assertKnownName(name);
        this.modifiedContent.put(name, content);
        this.deletedContent.remove(name);
    }

    public void delete(String name) {
        this.modifiedContent.remove(name);
        this.savedContent.remove(name);
        this.deletedContent.add(name);
    }

    public void listFiles(List<VirtualFile> list) {
        HashSet<String> existingFiles = new HashSet<String>(this.savedContent.keySet());
        existingFiles.addAll(this.modifiedContent.keySet());
        for (String key : existingFiles) {
            try {
                if (this.getVFile(key) == null) {
                    this.savedContent.remove(key);
                }
                list.add(this.getOrCreateVFile(key));
            }
            catch (IOException ignore) {}
        }
        HashSet<String> newFiles = new HashSet<String>(this.nameToDir.keySet());
        newFiles.removeAll(existingFiles);
        for (String name : newFiles) {
            VirtualFile vFile = this.getVFile(name);
            if (vFile == null) continue;
            list.add(vFile);
        }
    }

    public boolean hasChanged() {
        for (String key : this.modifiedContent.keySet()) {
            if (!this.hasChanged(key)) continue;
            return true;
        }
        return !this.deletedContent.isEmpty();
    }

    private boolean hasChanged(String key) {
        Document content = this.modifiedContent.get(key);
        Document physical1 = content == null ? null : content;
        Document physical2 = this.savedContent.get(key);
        if (physical1 != null && physical2 != null) {
            return !JDOMUtil.areDocumentsEqual((Document)physical1, (Document)physical2);
        }
        return physical1 != physical2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        for (String key : this.modifiedContent.keySet()) {
            Document content;
            if (!this.hasChanged(key) || (content = this.modifiedContent.get(key)) == null) continue;
            OutputStreamWriter writer = new OutputStreamWriter(this.getOrCreateVFile(key).getOutputStream((Object)this), "UTF-8");
            try {
                EclipseJDOMUtil.output(content, writer, this.project);
            }
            finally {
                ((Writer)writer).close();
            }
            this.savedContent.put(key, content);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (String deleted : CachedXmlDocumentSet.this.deletedContent) {
                    VirtualFile file = CachedXmlDocumentSet.this.getVFile(deleted);
                    if (file == null) continue;
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException ignore) {}
                }
                CachedXmlDocumentSet.this.deletedContent.clear();
            }
        });
    }
}

