/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.RandomAccessDataFile;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.Storage;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public class CompactStorage
extends AbstractStorage {
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_VERSION_OFFSET = 4;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int VERSION = 3;
    private static final int SAFELY_CLOSED_MAGIC = 523190098;
    private static final int SIZE_OFFSET = 0;
    private static final int CAPACITY_OFFSET = 4;
    private static final int DATA_OFFSET = 8;
    private static final byte[] ZEROES = new byte[8];
    private final RandomAccessDataFile myData;
    private boolean myIsDirty;
    private final Object lock = new Object();
    private static final int MAX_PAGES_TO_FLUSH_AT_A_TIME = 50;
    @NonNls
    private static final String DATA_EXTENSION = ".compact";
    @NonNls
    private static final String INDEX_EXTENSION = ".freeRecords";

    public static boolean deleteFiles(String storageFilePath) {
        File recordsFile = new File(storageFilePath + INDEX_EXTENSION);
        File dataFile = new File(storageFilePath + DATA_EXTENSION);
        boolean deletedRecordsFile = FileUtil.delete(recordsFile);
        boolean deletedDataFile = FileUtil.delete(dataFile);
        return deletedRecordsFile && deletedDataFile;
    }

    public CompactStorage(String storageFilePath) throws IOException {
        Storage.convertFromOldExtensions(storageFilePath);
        FileUtil.delete(new File(storageFilePath + ".storageRecordIndex"));
        FileUtil.delete(new File(storageFilePath + ".storageData"));
        File dataFile = new File(storageFilePath + DATA_EXTENSION);
        File recordsFile = new File(storageFilePath + INDEX_EXTENSION);
        FileUtil.createIfDoesntExist(recordsFile);
        FileUtil.createIfDoesntExist(dataFile);
        this.myData = new RandomAccessDataFile(dataFile, PagePool.SHARED);
        if (this.myData.length() == 0L) {
            this.myData.putInt(0L, 313341156);
            this.myData.putInt(4L, 0);
            this.myIsDirty = true;
        } else {
            this.readInHeader(dataFile);
        }
    }

    private void readInHeader(File filePath) throws IOException {
        int magic = this.myData.getInt(0L);
        if (magic != 523190098) {
            this.myData.dispose();
            throw new IOException("Records table for '" + filePath + "' haven't been closed correctly. Rebuild required.");
        }
    }

    private void cleanRecord(int record) {
        this.myData.put(record, ZEROES, 0, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.isDirty();
        }
    }

    @Override
    public void dispose() {
        this.markClean();
        this.myData.dispose();
    }

    @Override
    public void force() {
        this.markClean();
        this.myData.force();
    }

    public void markDirty() {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.myData.putInt(0L, 313341156);
        }
    }

    private void markClean() {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.myData.putInt(0L, 523190098);
        }
    }

    @Override
    public int createNewRecord(int requiredLength) {
        this.markDirty();
        int record = (int)this.myData.length();
        this.setSize(record, 0);
        int capacity = requiredLength;
        this.setCapacity(record, capacity);
        this.myData.put(record + 8 + capacity - 1, new byte[]{0}, 0, 1);
        return record;
    }

    @Override
    public void deleteRecord(int record) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes(int record) {
        Object object = this.lock;
        synchronized (object) {
            int size = this.getSize(record);
            assert (size >= 0) : "Record: " + record;
            byte[] bytes = new byte[size];
            this.myData.get(record + 8, bytes, 0, size);
            return bytes;
        }
    }

    @Override
    public void checkSanity(int record) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushSome() {
        Object object = this.lock;
        synchronized (object) {
            this.myData.flushSomePages(50);
            if (!this.myData.isDirty()) {
                this.force();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.getInt(4L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVersion(int expectedVersion) {
        Object object = this.lock;
        synchronized (object) {
            this.myData.putInt(4L, expectedVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int appendBytes(int record, byte[] bytes) {
        assert (record > 0);
        int delta = bytes.length;
        if (delta == 0) {
            return record;
        }
        Object object = this.lock;
        synchronized (object) {
            int capacity = this.getCapacity(record);
            int oldSize = this.getSize(record);
            int newSize = oldSize + delta;
            if (newSize > capacity) {
                if (oldSize > 0) {
                    byte[] newbytes = new byte[newSize];
                    System.arraycopy(this.readBytes(record), 0, newbytes, 0, oldSize);
                    System.arraycopy(bytes, 0, newbytes, oldSize, delta);
                    int newRecord = this.createNewRecord(0);
                    this.doWriteBytes(newRecord, newbytes, capacity, oldSize);
                    return newRecord;
                }
                int newRecord = this.createNewRecord(0);
                this.doWriteBytes(newRecord, bytes, capacity, oldSize);
                return newRecord;
            }
            this.myData.put(record + 8 + oldSize, bytes, 0, bytes.length);
            this.setSize(record, newSize);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(int record, byte[] bytes) {
        assert (record > 0);
        Object object = this.lock;
        synchronized (object) {
            int currentCapacity = this.getCapacity(record);
            int currentSize = this.getSize(record);
            assert (currentSize >= 0);
            this.doWriteBytes(record, bytes, currentCapacity, currentSize);
        }
    }

    @Override
    public int ensureCapacity(int record, int capacity) {
        int oldCapacity = this.getCapacity(record);
        if (oldCapacity < capacity) {
            return this.createNewRecord(0);
        }
        return record;
    }

    private void doWriteBytes(int record, byte[] bytes, int currentCapacity, int currentSize) {
        int requiredLength = bytes.length;
        if (requiredLength == 0 && currentSize == 0) {
            return;
        }
        assert (currentCapacity >= requiredLength);
        this.setSize(record, requiredLength);
        this.myData.put(record + 8, bytes, 0, bytes.length);
    }

    private void setCapacity(int record, int newCapacity) {
        this.myData.putInt(record + 4, newCapacity);
    }

    private int getCapacity(int record) {
        return this.myData.getInt(record + 4);
    }

    private int getSize(int record) {
        return this.myData.getInt(record + 0);
    }

    private void setSize(int record, int requiredLength) {
        this.myData.putInt(record + 0, requiredLength);
    }

    public void replaceIntInData(int attrsRecord, int recordId, int oldInt) {
        int old = this.myData.getInt(attrsRecord + 8);
        if (old != oldInt) {
            System.out.println("wtf");
        }
        this.myData.putInt(attrsRecord + 8, recordId);
    }
}

