/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.util.io.Bits;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.Page;
import com.intellij.util.io.PagePool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class RandomAccessDataFile
implements Forceable {
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(150, "rw");
    private static int ourFilesCount = 0;
    private final int myCount = ourFilesCount++;
    private final File myFile;
    private final PagePool myPool;
    private long lastSeek = -1L;
    private final byte[] myTypedIOBuffer = new byte[8];
    private final FileWriter log;
    private volatile long mySize;
    private volatile boolean myIsDirty = false;
    private static final boolean DEBUG = false;
    public static int totalReads = 0;
    public static long totalReadBytes = 0L;
    public static int seekcount = 0;
    public static int totalWrites = 0;
    public static long totalWriteBytes = 0L;

    public RandomAccessDataFile(File file) throws IOException {
        this(file, PagePool.SHARED);
    }

    public RandomAccessDataFile(File file, PagePool pool) throws IOException {
        this.myPool = pool;
        this.myFile = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath() + " does not exist");
        }
        this.mySize = file.length();
        this.log = null;
    }

    public void put(long addr, byte[] bytes, int off, int len) {
        this.myIsDirty = true;
        this.mySize = Math.max(this.mySize, addr + (long)len);
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int written = page.put(addr, bytes, off, len);
            len -= written;
            addr += (long)written;
            off += written;
        }
    }

    public void get(long addr, byte[] bytes, int off, int len) {
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int read = page.get(addr, bytes, off, len);
            len -= read;
            addr += (long)read;
            off += read;
        }
    }

    private void releaseFile() {
        ourCache.releaseChannel(this.myFile);
    }

    private RandomAccessFile getFile() throws FileNotFoundException {
        return ourCache.getChannel(this.myFile);
    }

    public void putInt(long addr, int value) {
        Bits.putInt(this.myTypedIOBuffer, 0, value);
        this.put(addr, this.myTypedIOBuffer, 0, 4);
    }

    public int getInt(long addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 4);
        return Bits.getInt(this.myTypedIOBuffer, 0);
    }

    public void putLong(long addr, long value) {
        Bits.putLong(this.myTypedIOBuffer, 0, value);
        this.put(addr, this.myTypedIOBuffer, 0, 8);
    }

    public void putByte(long addr, byte b) {
        this.myTypedIOBuffer[0] = b;
        this.put(addr, this.myTypedIOBuffer, 0, 1);
    }

    public byte getByte(long addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 1);
        return this.myTypedIOBuffer[0];
    }

    public long getLong(long addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 8);
        return Bits.getLong(this.myTypedIOBuffer, 0);
    }

    public String getUTF(long addr) {
        try {
            int len = this.getInt(addr);
            byte[] bytes = new byte[len];
            this.get(addr + 4L, bytes, 0, len);
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void putUTF(long addr, String value) {
        try {
            byte[] bytes = value.getBytes("UTF-8");
            this.putInt(addr, bytes.length);
            this.put(addr + 4L, bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    public long length() {
        return this.mySize;
    }

    public long physicalLength() {
        long res;
        try {
            res = this.getFile().length();
        }
        catch (IOException e) {
            return 0L;
        }
        this.releaseFile();
        return res;
    }

    public void dispose() {
        this.myPool.flushPages(this);
        ourCache.closeChannel(this.myFile);
    }

    @Override
    public void force() {
        if (this.isDirty()) {
            this.myPool.flushPages(this);
            this.myIsDirty = false;
        }
    }

    public void flushSomePages(int maxPagesToFlush) {
        if (this.isDirty()) {
            this.myIsDirty = !this.myPool.flushPages(this, maxPagesToFlush);
        }
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPage(Page page) {
        try {
            RandomAccessFile file = this.getFile();
            try {
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    this.seek(file, page.getOffset());
                    ByteBuffer buf = page.getBuf();
                    ++totalReads;
                    totalReadBytes += 4096L;
                    file.read(buf.array(), 0, 4096);
                    this.lastSeek += 4096L;
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flushPage(Page page, int start, int end) {
        try {
            this.flush(page.getBuf(), page.getOffset() + (long)start, start, end - start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ByteBuffer buf, long fileOffset, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.mySize) {
            length = (int)(this.mySize - fileOffset);
        }
        RandomAccessFile file = this.getFile();
        try {
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                this.seek(file, fileOffset);
                ++totalWrites;
                totalWriteBytes += (long)length;
                file.write(buf.array(), bufOffset, length);
                this.lastSeek += (long)length;
            }
        }
        finally {
            this.releaseFile();
        }
    }

    private void seek(RandomAccessFile file, long fileOffset) throws IOException {
        file.seek(fileOffset);
    }

    public int hashCode() {
        return this.myCount;
    }

    public synchronized String toString() {
        return "RandomAccessFile[" + this.myFile + ", dirty=" + this.myIsDirty + "]";
    }
}

