/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class Semaphore {
    private final Sync sync = new Sync();

    public void up() {
        this.sync.releaseShared(1);
    }

    public void down() {
        this.sync.down();
    }

    public void waitFor() {
        try {
            this.sync.acquireSharedInterruptibly(1);
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException(e);
        }
    }

    public boolean waitFor(long timeout) {
        try {
            if (this.sync.tryAcquireShared(1) >= 0) {
                return true;
            }
            return this.sync.tryAcquireSharedNanos(1, TimeUnit.MILLISECONDS.toNanos(timeout));
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException(e);
        }
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - 1));
            return nextc == 0;
        }

        final void down() {
            int next;
            int current;
            while (!this.compareAndSetState(current = this.getState(), next = current + 1)) {
            }
        }
    }
}

