/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CaptionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class TitlePanel
extends CaptionPanel {
    private final JLabel myLabel;
    private final Icon myRegular;
    private final Icon myInactive;

    public TitlePanel() {
        this(null, null);
    }

    public TitlePanel(Icon regular, Icon inactive) {
        this.myRegular = regular;
        this.myInactive = inactive;
        this.myLabel = new JLabel();
        this.myLabel.setOpaque(false);
        this.myLabel.setForeground(Color.black);
        this.myLabel.setHorizontalAlignment(0);
        this.myLabel.setVerticalAlignment(0);
        this.myLabel.setBorder(new EmptyBorder(1, 2, 2, 2));
        this.add((Component)this.myLabel, "Center");
        this.setActive(false);
    }

    public void setFontBold(boolean bold) {
        this.myLabel.setFont(this.myLabel.getFont().deriveFont(bold ? 1 : 0));
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.myLabel.setIcon(active ? this.myRegular : this.myInactive);
        this.myLabel.setForeground(active ? UIManager.getColor("Label.foreground") : Color.gray);
    }

    public void setText(String titleText) {
        this.myLabel.setText(titleText);
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.myLabel.getText();
        return text != null && text.trim().length() > 0 ? super.getPreferredSize() : new Dimension(0, 0);
    }
}

