/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public abstract class OptionalChooserComponent
implements CheckBoxListListener {
    private JPanel myContentPane;
    private CheckBoxList myList;
    private DefaultListModel myListModel;
    private List<Pair<String, Boolean>> myInitialList;
    private ArrayList<Pair<String, Boolean>> myWorkingList;

    public OptionalChooserComponent(@NotNull List<Pair<String, Boolean>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/OptionalChooserComponent.<init> must not be null");
        }
        this.myInitialList = list;
        this.$$$setupUI$$$();
        this.myWorkingList = new ArrayList<Pair<String, Boolean>>(this.myInitialList);
        this.reset();
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    @Override
    public void checkBoxSelectionChanged(int index, boolean value) {
        Pair<String, Boolean> pair = this.myWorkingList.remove(index);
        this.myWorkingList.add(index, Pair.create(pair.first, value));
    }

    private void createUIComponents() {
        this.myListModel = new DefaultListModel();
        this.myList = new CheckBoxList(this.myListModel, this);
    }

    public void reset() {
        this.myWorkingList = new ArrayList<Pair<String, Boolean>>(this.myInitialList);
        this.update();
    }

    public abstract JCheckBox createCheckBox(String var1, boolean var2);

    public boolean isModified() {
        return !this.myWorkingList.equals(this.myInitialList);
    }

    public ArrayList<Pair<String, Boolean>> getValue() {
        return this.myWorkingList;
    }

    public void apply() {
        this.myInitialList.clear();
        this.myInitialList.addAll(this.myWorkingList);
    }

    public void update() {
        this.myListModel.clear();
        for (Pair<String, Boolean> pair : this.myWorkingList) {
            this.myListModel.addElement(this.createCheckBox((String)pair.first, (Boolean)pair.second));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 7, 7, 7), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        CheckBoxList checkBoxList = this.myList;
        checkBoxList.setSelectionMode(0);
        jScrollPane.setViewportView(checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

