/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.containers.LockPoolSynchronizedMap;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDataHolderBase
implements UserDataHolderEx,
Cloneable {
    private static final Object MAP_LOCK = new Object();
    private static final Object COPYABLE_MAP_LOCK = new Object();
    private static final Key<Map<Key, Object>> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");
    private volatile ConcurrentMap<Key, Object> myUserMap = null;

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.myUserMap = null;
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUserDataString() {
        ConcurrentMap<Key, Object> userMap = this.myUserMap;
        if (userMap == null) {
            return "";
        }
        Map<Key, Object> copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        if (copyableMap == null) {
            return userMap.toString();
        }
        return userMap.toString() + copyableMap.toString();
    }

    public void copyUserDataTo(UserDataHolderBase other) {
        if (this.myUserMap == null) {
            other.myUserMap = null;
        } else {
            ConcurrentMap<Key, Object> fresh = this.createDataMap();
            fresh.putAll(this.myUserMap);
            other.myUserMap = fresh;
        }
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.getUserData must not be null");
        }
        ConcurrentMap<Key, Object> map = this.myUserMap;
        return map == null ? null : (T)map.get(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserData must not be null");
        }
        ConcurrentMap<Key, Object> map = this.getOrCreateMap();
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    protected ConcurrentMap<Key, Object> createDataMap() {
        return new LockPoolSynchronizedMap<Key, Object>(2, 0.9f);
    }

    public <T> T getCopyableUserData(Key<T> key) {
        return this.getCopyableUserDataImpl(key);
    }

    protected final <T> T getCopyableUserDataImpl(Key<T> key) {
        Map<Key, Object> map = this.getUserData(COPYABLE_USER_MAP_KEY);
        return (T)(map == null ? null : map.get(key));
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.putCopyableUserDataImpl(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> void putCopyableUserDataImpl(Key<T> key, T value) {
        Object object = COPYABLE_MAP_LOCK;
        synchronized (object) {
            Map<Key, Object> copyMap = this.getUserData(COPYABLE_USER_MAP_KEY);
            if (copyMap == null) {
                if (value == null) {
                    return;
                }
                copyMap = new LockPoolSynchronizedMap<Key, Object>(1, 0.9f);
                this.putUserData(COPYABLE_USER_MAP_KEY, copyMap);
            }
            if (value != null) {
                copyMap.put(key, value);
            } else {
                copyMap.remove(key);
                if (copyMap.isEmpty()) {
                    this.putUserData(COPYABLE_USER_MAP_KEY, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<Key, Object> getOrCreateMap() {
        ConcurrentMap<Key, Object> map = this.myUserMap;
        if (map == null) {
            Object object = MAP_LOCK;
            synchronized (object) {
                map = this.myUserMap;
                if (map == null) {
                    this.myUserMap = map = this.createDataMap();
                }
            }
        }
        return map;
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.replace must not be null");
        }
        return this.getOrCreateMap().replace(key, oldValue, newValue);
    }

    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not be null");
        }
        Object object = this.getOrCreateMap().putIfAbsent(key, value);
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/UserDataHolderBase.putUserDataIfAbsent must not return null");
        }
        return (T)object;
    }

    public void copyCopyableDataTo(UserDataHolderBase clone) {
        THashMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        if (copyableMap != null) {
            copyableMap = ((LockPoolSynchronizedMap)copyableMap).clone();
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, copyableMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearUserData() {
        Object object = MAP_LOCK;
        synchronized (object) {
            this.myUserMap = null;
        }
    }
}

