/*
 * Decompiled with CFR 0.152.
 */
package org.testng.v6;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ClassMethodMap;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.v6.IRunGroupFactory;
import org.testng.v6.Lists;
import org.testng.v6.Operation;
import org.testng.v6.Sets;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPlan {
    ClassMethodMap m_classMethodMap;
    private Map<ITestClass, Set<Object>> m_beforeClassMethods;
    private Set<ITestClass> m_classesSeen = Sets.newHashSet();
    private Set<String> m_groupsSeen = Sets.newHashSet();
    private List<List<ITestNGMethod>> m_sequentialList;
    private List<ITestNGMethod> m_parallelList;
    private List<Operation> m_operations;
    private ConfigurationGroupMethods m_groupMethods;
    private XmlTest m_xmlTest;
    private IRunGroupFactory m_runGroupFactory;
    private ITestNGMethod[] m_beforeSuiteMethods;
    private ITestNGMethod[] m_afterSuiteMethods;

    public TestPlan(List<List<ITestNGMethod>> sequentialList, List<ITestNGMethod> parallelList, ClassMethodMap cmm, ITestNGMethod[] beforeSuiteMethods, ITestNGMethod[] afterSuiteMethods, ConfigurationGroupMethods groupMethods, XmlTest xmlTest) {
        this.m_sequentialList = sequentialList;
        this.m_parallelList = parallelList;
        this.m_groupMethods = groupMethods;
        this.m_xmlTest = xmlTest;
        this.m_beforeSuiteMethods = beforeSuiteMethods;
        this.m_afterSuiteMethods = afterSuiteMethods;
        this.m_sequentialList = sequentialList;
        this.m_parallelList = parallelList;
        this.m_classMethodMap = cmm;
        this.m_beforeClassMethods = cmm.getInvokedBeforeClassMethods();
        this.m_operations = Lists.newArrayList();
    }

    public void init(IRunGroupFactory runGroupFactory) {
        this.m_runGroupFactory = runGroupFactory;
        int affinity = 1;
        for (List<ITestNGMethod> seq : this.m_sequentialList) {
            for (ITestNGMethod m : seq) {
                this.addTestOperation(this.createOperation(m, affinity, this.m_runGroupFactory));
            }
            ++affinity;
        }
        for (ITestNGMethod m : this.m_parallelList) {
            this.addTestOperation(this.createOperation(m, affinity, this.m_runGroupFactory));
        }
        this.addAfterClassAndGroupsMethods();
    }

    private void addAfterClassAndGroupsMethods() {
        Operation o;
        Set<Operation> afterOperations = Sets.newHashSet();
        for (ITestClass cl : this.m_classesSeen) {
            Integer id = this.m_runGroupFactory.findRunGroup(2, cl.getName());
            for (ITestNGMethod m : cl.getAfterClassMethods()) {
                o = this.createOperation(m, 0, this.m_runGroupFactory);
                o.setAfter(new Integer[]{id});
                afterOperations.add(o);
            }
        }
        Map<String, List<ITestNGMethod>> afterGroups = this.m_groupMethods.getAfterGroupsMethods();
        for (String group : this.m_groupsSeen) {
            List<ITestNGMethod> afterMethods = afterGroups.get(group);
            Integer id = this.m_runGroupFactory.findRunGroup(3, group);
            if (afterMethods == null) continue;
            for (ITestNGMethod m : afterMethods) {
                o = this.createOperation(m, 0, this.m_runGroupFactory);
                o.setAfter(new Integer[]{id});
                afterOperations.add(o);
            }
        }
        this.addAfterOperations(afterOperations);
    }

    private void addAfterOperations(Set<Operation> afterOperations) {
        Set<Operation> toRemove = Sets.newHashSet();
        for (int i = this.m_operations.size() - 1; i >= 0; --i) {
            Operation o = this.m_operations.get(i);
            for (Operation afterOperation : afterOperations) {
                if (!afterOperation.mustRunAfter(o)) continue;
                this.m_operations.add(i + 1, afterOperation);
                toRemove.add(afterOperation);
            }
            for (Operation afterOperation : toRemove) {
                afterOperations.remove(afterOperation);
            }
            if (afterOperations.size() == 0) break;
        }
    }

    private void addTestOperation(Operation o) {
        String[] groups;
        ITestNGMethod method = o.getMethod();
        ITestClass testClass = method.getTestClass();
        if (!this.m_classesSeen.contains(testClass)) {
            this.m_classesSeen.add(testClass);
            this.addMethods(testClass.getBeforeClassMethods(), o.getAffinity(), this.m_operations.size());
        }
        for (String group : groups = method.getGroups()) {
            List<ITestNGMethod> beforeMethods;
            if (this.m_groupsSeen.contains(group) || (beforeMethods = this.m_groupMethods.getBeforeGroupsMap().get(group)) == null) continue;
            ITestNGMethod[] beforeGroupMethods = beforeMethods.toArray(new ITestNGMethod[beforeMethods.size()]);
            this.addMethods(beforeGroupMethods, o.getAffinity(), this.m_operations.size());
            this.m_groupsSeen.add(group);
        }
        this.addMethods(testClass.getBeforeTestMethods(), o.getAffinity(), this.m_operations.size());
        this.m_operations.add(o);
        this.addMethods(testClass.getAfterTestMethods(), o.getAffinity(), this.m_operations.size());
    }

    private void addMethods(ITestNGMethod[] methods, int affinity, int index) {
        for (ITestNGMethod m : methods) {
            this.m_operations.add(index, this.createOperation(m, affinity, this.m_runGroupFactory));
        }
    }

    private Operation createOperation(ITestNGMethod m, int affinity, IRunGroupFactory factory) {
        Operation result = new Operation(m, factory, this.m_xmlTest);
        return result;
    }

    private Operation createOperation(ITestNGMethod m, IRunGroupFactory factory) {
        return this.createOperation(m, 0, factory);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (Operation o : this.m_operations) {
            result.append("   ").append(o).append("\n");
        }
        return result.toString();
    }

    private void p(String string) {
        System.out.println(string);
    }
}

