/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class XMLUtils {
    private static final String EOL = System.getProperty("line.separator");

    private XMLUtils() {
    }

    public static String xml(String indent, String elementName, String content, Properties attributes) {
        StringBuffer result = new StringBuffer();
        XMLUtils.xmlOpen(result, indent, elementName, attributes, true);
        result.append(content);
        XMLUtils.xmlClose(result, "", elementName);
        return result.toString();
    }

    public static void xmlOptional(StringBuffer result, String sp, String elementName, Boolean value, Properties attributes) {
        if (null != value) {
            XMLUtils.xmlRequired(result, sp, elementName, value.toString(), attributes);
        }
    }

    public static void xmlOptional(StringBuffer result, String sp, String elementName, String value, Properties attributes) {
        if (null != value) {
            XMLUtils.xmlRequired(result, sp, elementName, value, attributes);
        }
    }

    public static void xmlRequired(StringBuffer result, String sp, String elementName, String value, Properties attributes) {
        result.append(XMLUtils.xml(sp, elementName, value, attributes));
    }

    public static void xmlOpen(StringBuffer result, String indent, String tag, Properties attributes) {
        XMLUtils.xmlOpen(result, indent, tag, attributes, false);
    }

    public static void appendAttributes(StringBuffer result, Properties attributes) {
        if (null != attributes) {
            Iterator<Map.Entry<Object, Object>> it = attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = entry.getKey().toString();
                String value = XMLUtils.escape(entry.getValue().toString());
                result.append(" ").append(key).append("=\"").append(value).append("\"");
            }
        }
    }

    public static void xmlOpen(StringBuffer result, String indent, String tag, Properties attributes, boolean noNewLine) {
        result.append(indent).append("<").append(tag);
        XMLUtils.appendAttributes(result, attributes);
        result.append(">");
        if (!noNewLine) {
            result.append(EOL);
        }
    }

    public static void xmlClose(StringBuffer result, String indent, String tag) {
        result.append(indent).append("</").append(tag).append(">").append(EOL);
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(input);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

