/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParameterizable;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.ClassHelper;
import org.testng.internal.DataProviderHolder;
import org.testng.internal.MethodHelper;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    public static final String NULL_VALUE = "null";
    static /* synthetic */ Class class$org$testng$annotations$IConfigurationAnnotation;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$org$testng$ITestContext;
    static /* synthetic */ Class class$org$testng$xml$XmlTest;
    static /* synthetic */ Class class$org$testng$ITestResult;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$testng$internal$Parameters;
    static /* synthetic */ Class class$org$testng$annotations$IDataProviderAnnotation;
    static /* synthetic */ Class class$org$testng$annotations$IParametersAnnotation;
    static /* synthetic */ Class class$org$testng$annotations$ITestAnnotation;

    public static Object[] createInstantiationParameters(Constructor ctor, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParameters(ctor.toString(), ctor.getParameterTypes(), finder.findOptionalValues(ctor), methodAnnotation, finder, parameterNames, new MethodParameters(params), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, Object[] parameterValues, ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite, ITestContext ctx, ITestResult testResult) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getMethod() : null;
        return Parameters.createParameters(m, new MethodParameters(params, parameterValues, currentTestMeth, ctx, testResult), finder, xmlSuite, class$org$testng$annotations$IConfigurationAnnotation == null ? (class$org$testng$annotations$IConfigurationAnnotation = Parameters.class$("org.testng.annotations.IConfigurationAnnotation")) : class$org$testng$annotations$IConfigurationAnnotation, "@Configuration");
    }

    private static Object[] createParameters(String methodName, Class[] parameterTypes, String[] optionalValues, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Object[] result = new Object[]{};
        if (parameterTypes.length > 0) {
            ArrayList<Object> vResult = new ArrayList<Object>();
            Parameters.checkParameterTypes(methodName, parameterTypes, methodAnnotation, parameterNames);
            int j = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if ((class$java$lang$reflect$Method == null ? Parameters.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method).equals(parameterTypes[i])) {
                    vResult.add(params.currentTestMethod);
                    continue;
                }
                if ((class$org$testng$ITestContext == null ? Parameters.class$("org.testng.ITestContext") : class$org$testng$ITestContext).equals(parameterTypes[i])) {
                    vResult.add(params.context);
                    continue;
                }
                if ((class$org$testng$xml$XmlTest == null ? Parameters.class$("org.testng.xml.XmlTest") : class$org$testng$xml$XmlTest).equals(parameterTypes[i])) {
                    vResult.add(params.context.getCurrentXmlTest());
                    continue;
                }
                if ((class$org$testng$ITestResult == null ? Parameters.class$("org.testng.ITestResult") : class$org$testng$ITestResult).equals(parameterTypes[i])) {
                    vResult.add(params.testResult);
                    continue;
                }
                if (j >= parameterNames.length) continue;
                String p = parameterNames[j];
                String value = (String)params.xmlParameters.get(p);
                if (null == value) {
                    value = System.getProperty(p);
                }
                if (null == value) {
                    if (optionalValues != null) {
                        value = optionalValues[i];
                    }
                    if (null == value) {
                        throw new TestNGException(new StringBuffer().append("Parameter '").append(p).append("' is required by ").append(methodAnnotation).append(" on method ").append(methodName).append("\nbut has not been marked @Optional or defined ").append(xmlSuite.getFileName() != null ? new StringBuffer().append("in ").append(xmlSuite.getFileName()).toString() : "").toString());
                    }
                }
                vResult.add(Parameters.convertType(parameterTypes[i], value, p));
                ++j;
            }
            result = vResult.toArray(new Object[vResult.size()]);
        }
        return result;
    }

    private static void checkParameterTypes(String methodName, Class[] parameterTypes, String methodAnnotation, String[] parameterNames) {
        if (parameterNames.length == parameterTypes.length) {
            return;
        }
        for (int i = parameterTypes.length - 1; i >= parameterNames.length; --i) {
            Class type;
            if ((class$org$testng$ITestContext == null ? Parameters.class$("org.testng.ITestContext") : class$org$testng$ITestContext).equals(type = parameterTypes[i]) || (class$org$testng$ITestResult == null ? Parameters.class$("org.testng.ITestResult") : class$org$testng$ITestResult).equals(type) || (class$org$testng$xml$XmlTest == null ? Parameters.class$("org.testng.xml.XmlTest") : class$org$testng$xml$XmlTest).equals(type) || (class$java$lang$reflect$Method == null ? Parameters.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method).equals(type) || (array$Ljava$lang$Object == null ? Parameters.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object).equals(type)) continue;
            throw new TestNGException(new StringBuffer().append("Method ").append(methodName).append(" requires ").append(parameterTypes.length).append(" parameters but ").append(parameterNames.length).append(" were supplied in the ").append(methodAnnotation).append(" annotation.").toString());
        }
    }

    public static Object convertType(Class type, String value, String paramName) {
        Object result = null;
        if (NULL_VALUE.equals(value.toLowerCase())) {
            if (type.isPrimitive()) {
                Utils.log("Parameters", 2, new StringBuffer().append("Attempt to pass null value to primitive type parameter '").append(paramName).append("'").toString());
            }
            return null;
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = Parameters.class$("java.lang.String")) : class$java$lang$String)) {
            result = value;
        } else if (type == Integer.TYPE || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Parameters.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            result = new Integer(Integer.parseInt(value));
        } else if (type == Boolean.TYPE || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Parameters.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            result = Boolean.valueOf(value);
        } else if (type == Byte.TYPE || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Parameters.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            result = new Byte(Byte.parseByte(value));
        } else if (type == Character.TYPE || type == (class$java$lang$Character == null ? (class$java$lang$Character = Parameters.class$("java.lang.Character")) : class$java$lang$Character)) {
            result = new Character(value.charAt(0));
        } else if (type == Double.TYPE || type == (class$java$lang$Double == null ? (class$java$lang$Double = Parameters.class$("java.lang.Double")) : class$java$lang$Double)) {
            result = new Double(Double.parseDouble(value));
        } else if (type == Float.TYPE || type == (class$java$lang$Float == null ? (class$java$lang$Float = Parameters.class$("java.lang.Float")) : class$java$lang$Float)) {
            result = new Float(Float.parseFloat(value));
        } else if (type == Long.TYPE || type == (class$java$lang$Long == null ? (class$java$lang$Long = Parameters.class$("java.lang.Long")) : class$java$lang$Long)) {
            result = new Long(Long.parseLong(value));
        } else if (type == Short.TYPE || type == (class$java$lang$Short == null ? (class$java$lang$Short = Parameters.class$("java.lang.Short")) : class$java$lang$Short)) {
            result = new Short(Short.parseShort(value));
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)new StringBuffer().append("Unsupported type parameter : ").append(type).toString());
        }
        return result;
    }

    private static DataProviderHolder findDataProvider(Class clazz, Method m, IAnnotationFinder finder) {
        IFactoryAnnotation factory;
        DataProviderHolder result = null;
        String dataProviderName = null;
        Class<?> dataProviderClass = null;
        ITestAnnotation annotation = AnnotationHelper.findTest(finder, m);
        if (annotation == null) {
            annotation = AnnotationHelper.findTest(finder, clazz);
        }
        if (annotation != null) {
            dataProviderName = annotation.getDataProvider();
            dataProviderClass = annotation.getDataProviderClass();
        }
        if (dataProviderName == null && (factory = AnnotationHelper.findFactory(finder, m)) != null) {
            dataProviderName = factory.getDataProvider();
            dataProviderClass = null;
        }
        if (null != dataProviderName && !"".equals(dataProviderName) && null == (result = Parameters.findDataProvider(clazz, finder, dataProviderName, dataProviderClass))) {
            throw new TestNGException(new StringBuffer().append("Method ").append(m).append(" requires a @DataProvider named : ").append(dataProviderName).append(dataProviderClass != null ? new StringBuffer().append(" in class ").append(dataProviderClass.getName()).toString() : "").toString());
        }
        return result;
    }

    private static DataProviderHolder findDataProvider(Class cls, IAnnotationFinder finder, String name, Class dataProviderClass) {
        boolean shouldBeStatic = false;
        if (dataProviderClass != null) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            IDataProviderAnnotation dp = (IDataProviderAnnotation)finder.findAnnotation(m, class$org$testng$annotations$IDataProviderAnnotation == null ? Parameters.class$("org.testng.annotations.IDataProviderAnnotation") : class$org$testng$annotations$IDataProviderAnnotation);
            if (null == dp || !name.equals(dp.getName()) && !name.equals(m.getName())) continue;
            if (shouldBeStatic && (m.getModifiers() & 8) == 0) {
                throw new TestNGException(new StringBuffer().append("DataProvider should be static: ").append(m).toString());
            }
            return new DataProviderHolder(dp, m);
        }
        return null;
    }

    private static Object[] createParameters(Method m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, Class annotationClass, String atName) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] extraParameters = new Object[]{};
        IParametersAnnotation annotation = (IParametersAnnotation)finder.findAnnotation(m, class$org$testng$annotations$IParametersAnnotation == null ? (class$org$testng$annotations$IParametersAnnotation = Parameters.class$("org.testng.annotations.IParametersAnnotation")) : class$org$testng$annotations$IParametersAnnotation);
        Class[] types = m.getParameterTypes();
        if (null != annotation) {
            String[] parameterNames = annotation.getValue();
            extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
        } else {
            IParameterizable a = (IParameterizable)finder.findAnnotation(m, annotationClass);
            if (null != a && a.getParameters().length > 0) {
                String[] parameterNames = a.getParameters();
                extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
            } else {
                extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, new String[0], params, xmlSuite);
            }
        }
        for (int i = 0; i < types.length; ++i) {
            Class type;
            if (!(array$Ljava$lang$Object == null ? Parameters.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object).equals(type = types[i])) continue;
            result.add(params.parameterValues);
        }
        for (Object p : extraParameters) {
            result.add(p);
        }
        return result.toArray(new Object[result.size()]);
    }

    public static ParameterHolder handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance) {
        ParameterHolder result;
        Iterator<Object[]> parameters = null;
        DataProviderHolder dataProviderHolder = Parameters.findDataProvider(testMethod.getTestClass().getRealClass(), testMethod.getMethod(), annotationFinder);
        if (null != dataProviderHolder) {
            int parameterCount = testMethod.getMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = new StringBuffer().append("param").append(i).toString();
                allParameterNames.put(n, n);
            }
            parameters = MethodHelper.invokeDataProvider(instance, dataProviderHolder.method, testMethod, methodParams.context, fedInstance, annotationFinder);
            result = new ParameterHolder(parameters, 1, dataProviderHolder);
        } else {
            allParameterNames.putAll(methodParams.xmlParameters);
            Object[][] allParameterValuesArray = new Object[][]{Parameters.createParameters(testMethod.getMethod(), methodParams, annotationFinder, xmlSuite, class$org$testng$annotations$ITestAnnotation == null ? (class$org$testng$annotations$ITestAnnotation = Parameters.class$("org.testng.annotations.ITestAnnotation")) : class$org$testng$annotations$ITestAnnotation, "@Test")};
            testMethod.setParameterInvocationCount(allParameterValuesArray.length);
            parameters = MethodHelper.createArrayIterator(allParameterValuesArray);
            result = new ParameterHolder(parameters, allParameterValuesArray.length == 0 ? 1 : 2, dataProviderHolder);
        }
        return result;
    }

    private static void ppp(String s) {
        System.out.println(new StringBuffer().append("[Parameters] ").append(s).toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$testng$internal$Parameters == null ? (class$org$testng$internal$Parameters = Parameters.class$("org.testng.internal.Parameters")) : class$org$testng$internal$Parameters).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;
        private Object[] parameterValues;
        public ITestResult testResult;

        public MethodParameters(Map<String, String> params) {
            this(params, null, null, null, null);
        }

        public MethodParameters(Map<String, String> params, Method m) {
            this(params, null, m, null, null);
        }

        public MethodParameters(Map<String, String> params, Object[] pv, Method m, ITestContext ctx, ITestResult tr) {
            this.xmlParameters = params;
            this.currentTestMethod = m;
            this.context = ctx;
            this.parameterValues = pv;
            this.testResult = tr;
        }
    }
}

