/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.Tarjan;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T> {
    private static boolean m_verbose;
    private Map<T, Node<T>> m_nodes = new HashMap<T, Node<T>>();
    private List<T> m_strictlySortedNodes = null;
    private Map<T, Node<T>> m_independentNodes = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$testng$internal$Graph;

    public void addNode(T tm) {
        Graph.ppp(new StringBuffer().append("ADDING NODE ").append(tm).append(" ").append(tm.hashCode()).toString());
        this.m_nodes.put(tm, new Node<T>(tm));
    }

    public Set<T> getPredecessors(T node) {
        return this.findNode(node).getPredecessors().keySet();
    }

    public boolean isIndependent(T object) {
        return this.m_independentNodes.containsKey(object);
    }

    private Node<T> findNode(T object) {
        return this.m_nodes.get(object);
    }

    public void addPredecessor(T tm, T predecessor) {
        Node<T> node = this.findNode(tm);
        if (null == node) {
            throw new TestNGException(new StringBuffer().append("Non-existing node: ").append(tm).toString());
        }
        node.addPredecessor(predecessor);
        this.addNeighbor(tm, predecessor);
        if (null == this.m_independentNodes) {
            this.m_independentNodes = new HashMap<T, Node<T>>();
            for (T k : this.m_nodes.keySet()) {
                this.m_independentNodes.put(k, this.m_nodes.get(k));
            }
        }
        this.m_independentNodes.remove(predecessor);
        this.m_independentNodes.remove(tm);
        Graph.ppp(new StringBuffer().append("  REMOVED ").append(predecessor).append(" FROM INDEPENDENT OBJECTS").toString());
    }

    private void addNeighbor(T tm, T predecessor) {
        this.findNode(tm).addNeighbor(this.findNode(predecessor));
    }

    public Set<T> getNeighbors(T t) {
        HashSet<T> result = new HashSet<T>();
        for (Node<T> n : this.findNode(t).getNeighbors()) {
            result.add(n.getObject());
        }
        return result;
    }

    private Collection<Node<T>> getNodes() {
        return this.m_nodes.values();
    }

    public Collection<T> getNodeValues() {
        return this.m_nodes.keySet();
    }

    public Set<T> getIndependentNodes() {
        return this.m_independentNodes.keySet();
    }

    public List<T> getStrictlySortedNodes() {
        return this.m_strictlySortedNodes;
    }

    public void topologicalSort() {
        Graph.ppp("================ SORTING");
        this.m_strictlySortedNodes = new ArrayList<T>();
        if (null == this.m_independentNodes) {
            this.m_independentNodes = new HashMap<T, Node<T>>();
        }
        ArrayList<Node<T>> nodes2 = new ArrayList<Node<T>>();
        for (Node<T> n : this.getNodes()) {
            if (!this.isIndependent(n.getObject())) {
                Graph.ppp(new StringBuffer().append("ADDING FOR SORT: ").append(n.getObject()).toString());
                nodes2.add((Node<T>)n.clone());
                continue;
            }
            Graph.ppp(new StringBuffer().append("SKIPPING INDEPENDENT NODE ").append(n).toString());
        }
        Collections.sort(nodes2);
        while (!nodes2.isEmpty()) {
            Node<T> node = this.findNodeWithNoPredecessors(nodes2);
            if (null == node) {
                List cycle = new Tarjan(this, ((Node)nodes2.get(0)).getObject()).getCycle();
                StringBuffer sb = new StringBuffer();
                sb.append("The following methods have cyclic dependencies:\n");
                for (Object m : cycle) {
                    sb.append(m).append("\n");
                }
                throw new TestNGException(sb.toString());
            }
            this.m_strictlySortedNodes.add(node.getObject());
            this.removeFromNodes(nodes2, node);
        }
        Graph.ppp("=============== DONE SORTING");
        if (m_verbose) {
            this.dumpSortedNodes();
        }
    }

    private void dumpSortedNodes() {
        System.out.println("====== SORTED NODES");
        for (T n : this.m_strictlySortedNodes) {
            System.out.println(new StringBuffer().append("              ").append(n).toString());
        }
        System.out.println("====== END SORTED NODES");
    }

    private void dumpGraph() {
        System.out.println("====== GRAPH");
        for (Node<T> n : this.m_nodes.values()) {
            System.out.println(new StringBuffer().append("  ").append(n).toString());
        }
    }

    private void removeFromNodes(List<Node<T>> nodes, Node<T> node) {
        nodes.remove(node);
        for (Node<T> n : nodes) {
            n.removePredecessor(node.getObject());
        }
    }

    private static void ppp(String s) {
        if (m_verbose) {
            System.out.println(new StringBuffer().append("[Graph] ").append(s).toString());
        }
    }

    private Node<T> findNodeWithNoPredecessors(List<Node<T>> nodes) {
        for (Node<T> n : nodes) {
            if (n.hasPredecessors()) continue;
            return n;
        }
        return null;
    }

    public List<T> findPredecessors(T o) {
        Node<T> node = this.findNode(o);
        if (null == node) {
            return Lists.newArrayList();
        }
        LinkedList result = new LinkedList();
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> queue = new LinkedList<Object>();
        visited.add(o);
        queue.addLast(o);
        while (!queue.isEmpty()) {
            for (Object obj : this.getPredecessors(queue.removeFirst())) {
                if (visited.contains(obj)) continue;
                visited.add(obj);
                queue.addLast(obj);
                result.addFirst(obj);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Graph ");
        for (T node : this.m_nodes.keySet()) {
            result.append(this.findNode(node)).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public static void main(String[] argv) {
        Graph<String> g = new Graph<String>();
        g.addNode("3");
        g.addNode("1");
        g.addNode("2.2");
        g.addNode("independent");
        g.addNode("2.1");
        g.addNode("2.3");
        g.addPredecessor("3", "2.1");
        g.addPredecessor("3", "2.1");
        g.addPredecessor("3", "2.3");
        g.addPredecessor("2.1", "1");
        g.addPredecessor("2.2", "1");
        g.addPredecessor("2.3", "1");
        g.topologicalSort();
        List l = g.getStrictlySortedNodes();
        for (String s : l) {
            System.out.println(new StringBuffer().append("  ").append(s).toString());
        }
        int i = 0;
        if (!$assertionsDisabled && !"1".equals(l.get(i))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || "2.1".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || "2.1".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || "2.1".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !"3".equals(l.get(++i))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 1 != g.getIndependentNodes().size()) {
            throw new AssertionError();
        }
        Graph.ppp(new StringBuffer().append("GRAPH:").append(g).toString());
        List<String> predecessors = g.findPredecessors("2.1");
        if (!$assertionsDisabled && predecessors.size() != 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !predecessors.get(0).equals("1")) {
            throw new AssertionError();
        }
        predecessors = g.findPredecessors("3");
        if (!$assertionsDisabled && predecessors.size() != 4) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !predecessors.get(0).equals("1")) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || predecessors.get(1).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || predecessors.get(2).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || predecessors.get(3).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"))) {
            throw new AssertionError();
        }
        Graph.ppp("TESTS PASSED");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$testng$internal$Graph == null ? (class$org$testng$internal$Graph = Graph.class$("org.testng.internal.Graph")) : class$org$testng$internal$Graph).desiredAssertionStatus();
        m_verbose = false;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node<T>
    implements Comparable<Node<T>> {
        private T m_object = null;
        private Map<T, T> m_predecessors = new HashMap<T, T>();
        private Set<Node<T>> m_neighbors = new HashSet<Node<T>>();

        public Node(T tm) {
            this.m_object = tm;
        }

        public void addNeighbor(Node<T> neighbor) {
            this.m_neighbors.add(neighbor);
        }

        public Set<Node<T>> getNeighbors() {
            return this.m_neighbors;
        }

        public Node<T> clone() {
            Node<T> result = new Node<T>(this.m_object);
            for (T pred : this.m_predecessors.values()) {
                result.addPredecessor(pred);
            }
            return result;
        }

        public T getObject() {
            return this.m_object;
        }

        public Map<T, T> getPredecessors() {
            return this.m_predecessors;
        }

        public boolean removePredecessor(T o) {
            boolean result = false;
            T pred = this.m_predecessors.get(o);
            if (null != pred) {
                boolean bl = result = null != this.m_predecessors.remove(o);
                if (result) {
                    Graph.ppp(new StringBuffer().append("  REMOVED PRED ").append(o).append(" FROM NODE ").append(this.m_object).toString());
                } else {
                    Graph.ppp(new StringBuffer().append("  FAILED TO REMOVE PRED ").append(o).append(" FROM NODE ").append(this.m_object).toString());
                }
            }
            return result;
        }

        private void dump() {
            Graph.ppp(this.toString());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(new StringBuffer().append("[Node:").append(this.m_object).toString());
            sb.append("  pred:");
            for (T o : this.m_predecessors.values()) {
                sb.append(new StringBuffer().append(" ").append(o.toString()).toString());
            }
            sb.append("]");
            String result = sb.toString();
            return result;
        }

        public void addPredecessor(T tm) {
            Graph.ppp(new StringBuffer().append("  ADDING PREDECESSOR FOR ").append(this.m_object).append(" ==> ").append(tm).toString());
            this.m_predecessors.put(tm, tm);
        }

        public boolean hasPredecessors() {
            return this.m_predecessors.size() > 0;
        }

        public boolean hasPredecessor(T m) {
            return this.m_predecessors.containsKey(m);
        }

        @Override
        public int compareTo(Node<T> o) {
            return this.getObject().toString().compareTo(o.getObject().toString());
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.clone();
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((Node)x0);
        }
    }
}

