/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.history;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsRevisionNumber
implements VcsRevisionNumber {
    private final String myStringRepresentation;
    @Nullable
    private final int[] mySubRevisions;
    private final DateOrRevisionSettings myDateOrRevision;
    public static CvsRevisionNumber CURRENT = new CvsRevisionNumber(CvsBundle.message("current.file.revision.name", new Object[0]), ArrayUtil.EMPTY_INT_ARRAY){

        @Override
        protected int compareToCvsRevisionNumber(CvsRevisionNumber other) {
            return 1;
        }

        @Override
        public int compareTo(VcsRevisionNumber o) {
            return 1;
        }
    };
    public static CvsRevisionNumber EMPTY = new CvsRevisionNumber("", ArrayUtil.EMPTY_INT_ARRAY){

        @Override
        protected int compareToCvsRevisionNumber(CvsRevisionNumber other) {
            return -1;
        }

        @Override
        public int compareTo(VcsRevisionNumber o) {
            return -1;
        }
    };

    public CvsRevisionNumber(@NonNls String revision) {
        this(revision, CvsRevisionNumber.parseRevisionString(revision));
    }

    public CvsRevisionNumber(@NotNull DateOrRevisionSettings dateOrRevision) {
        if (dateOrRevision == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/history/CvsRevisionNumber.<init> must not be null");
        }
        this(dateOrRevision.asString(), dateOrRevision);
    }

    private static int[] parseRevisionString(String revision) {
        String[] stringSubRevisions = revision.split("\\.");
        int[] subRevisions = new int[stringSubRevisions.length];
        int cnt = 0;
        for (int i = 0; i < stringSubRevisions.length; ++i) {
            try {
                subRevisions[i] = Integer.parseInt(stringSubRevisions[i]);
                ++cnt;
                continue;
            }
            catch (NumberFormatException ex) {
                subRevisions[i] = 0;
            }
        }
        return cnt == 0 ? new int[]{} : subRevisions;
    }

    private CvsRevisionNumber(String sringRepresentation, @NotNull int[] subRevisions) {
        if (subRevisions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/cvsSupport2/history/CvsRevisionNumber.<init> must not be null");
        }
        this.myStringRepresentation = sringRepresentation;
        this.mySubRevisions = subRevisions;
        this.myDateOrRevision = null;
    }

    private CvsRevisionNumber(String stringRepresentation, @NotNull DateOrRevisionSettings dateOrRevision) {
        if (dateOrRevision == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/cvsSupport2/history/CvsRevisionNumber.<init> must not be null");
        }
        this.myStringRepresentation = stringRepresentation;
        this.mySubRevisions = null;
        this.myDateOrRevision = dateOrRevision;
    }

    protected int compareToCvsRevisionNumber(CvsRevisionNumber other) {
        if (this.mySubRevisions != null && other.mySubRevisions != null) {
            if (other.mySubRevisions.length > this.mySubRevisions.length) {
                return -other.compareToCvsRevisionNumber(this);
            }
            for (int i = 0; i < this.mySubRevisions.length; ++i) {
                int subRevision = this.mySubRevisions[i];
                int otherSubRevision = other.getSubRevisionAt(i);
                if (subRevision == otherSubRevision) continue;
                return subRevision > otherSubRevision ? 1 : -1;
            }
        } else if (this.myDateOrRevision != null && other.myDateOrRevision != null) {
            return this.myDateOrRevision.compareTo(other.myDateOrRevision);
        }
        return 0;
    }

    public int compareTo(VcsRevisionNumber o) {
        if (o instanceof CvsRevisionNumber) {
            CvsRevisionNumber other = (CvsRevisionNumber)o;
            return -other.compareToCvsRevisionNumber(this);
        }
        return 0;
    }

    private int getSubRevisionAt(int i) {
        if (this.mySubRevisions != null && i < this.mySubRevisions.length) {
            return this.mySubRevisions[i];
        }
        return 0;
    }

    public int hashCode() {
        return this.myStringRepresentation.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CvsRevisionNumber)) {
            return false;
        }
        return this.myStringRepresentation.equals(((CvsRevisionNumber)obj).myStringRepresentation);
    }

    public String toString() {
        return this.myStringRepresentation;
    }

    public String asString() {
        return this.myStringRepresentation;
    }

    public CvsRevisionNumber removeTailVersions(int i) {
        if (this.mySubRevisions != null && this.mySubRevisions.length < i) {
            return this;
        }
        int[] resultSubVersions = new int[this.mySubRevisions.length - i];
        System.arraycopy(this.mySubRevisions, 0, resultSubVersions, 0, resultSubVersions.length);
        return new CvsRevisionNumber(CvsRevisionNumber.createStringRepresentation(resultSubVersions), resultSubVersions);
    }

    public CvsRevisionNumber getPrevNumber() {
        if (this.mySubRevisions == null || this.mySubRevisions.length == 0) {
            return this;
        }
        int length = this.mySubRevisions.length;
        int[] resultSubVersions = new int[length];
        System.arraycopy(this.mySubRevisions, 0, resultSubVersions, 0, length);
        int n = length - 1;
        resultSubVersions[n] = resultSubVersions[n] - 1;
        return new CvsRevisionNumber(CvsRevisionNumber.createStringRepresentation(resultSubVersions), resultSubVersions);
    }

    private static String createStringRepresentation(int[] versions) {
        return StringUtil.join((int[])versions, (String)".");
    }

    public CvsRevisionNumber addTailVersions(int ... versions) {
        if (this.mySubRevisions != null) {
            int[] resultSubVersions = new int[this.mySubRevisions.length + versions.length];
            System.arraycopy(this.mySubRevisions, 0, resultSubVersions, 0, this.mySubRevisions.length);
            System.arraycopy(versions, 0, resultSubVersions, this.mySubRevisions.length, versions.length);
            return new CvsRevisionNumber(CvsRevisionNumber.createStringRepresentation(resultSubVersions), resultSubVersions);
        }
        return this;
    }

    public boolean isTopVersion() {
        if (this.mySubRevisions != null) {
            return this.mySubRevisions.length <= 2;
        }
        return false;
    }

    public DateOrRevisionSettings getDateOrRevision() {
        return this.myDateOrRevision;
    }

    @Nullable
    public int[] getSubRevisions() {
        return this.mySubRevisions;
    }
}

