/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.ConnectionPoolI;
import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionUtils;
import com.intellij.openapi.components.ServiceManager;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class EmptyPool
implements ConnectionPoolI {
    public static EmptyPool getInstance() {
        return (EmptyPool)ServiceManager.getService(EmptyPool.class);
    }

    @Override
    public IConnection getConnection(String repository, ConnectionSettings connectionSettings, SshAuthentication authentication) {
        return new MySimpleConnection(repository, connectionSettings, authentication);
    }

    private static class MySimpleConnection
    implements IConnection {
        private final String myRepository;
        private Connection myConnection;
        private Session mySession;
        private final ConnectionSettings myConnectionSettings;
        private final SshAuthentication myAuthentication;

        private MySimpleConnection(String repository, ConnectionSettings connectionSettings, SshAuthentication authentication) {
            this.myConnectionSettings = connectionSettings;
            this.myAuthentication = authentication;
            this.myRepository = repository;
        }

        public InputStream getInputStream() {
            return this.mySession.getStdout();
        }

        public OutputStream getOutputStream() {
            return this.mySession.getStdin();
        }

        public String getRepository() {
            return this.myRepository;
        }

        public void verify(IStreamLogger streamLogger) throws AuthenticationException {
        }

        public void open(IStreamLogger streamLogger) throws AuthenticationException {
            try {
                this.myConnection = SshConnectionUtils.openConnection(this.myConnectionSettings, this.myAuthentication);
                this.mySession = this.myConnection.openSession();
                this.mySession.execCommand("cvs server");
                new StreamGobbler(this.mySession.getStderr());
            }
            catch (IOException e) {
                throw new AuthenticationException(e.getMessage(), (Throwable)e);
            }
        }

        public void close() throws IOException {
            try {
                this.mySession.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.myConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

