/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenIcons;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;

public class MavenFrameworkSupportProvider
extends FrameworkSupportProvider {
    public MavenFrameworkSupportProvider() {
        super(MavenFrameworkSupportProvider.class.getName(), "Maven");
    }

    @NotNull
    public FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider.createConfigurable must not be null");
        }
        FrameworkSupportConfigurable frameworkSupportConfigurable = new FrameworkSupportConfigurable(){

            public JComponent getComponent() {
                return new JPanel();
            }

            public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel model, @Nullable Library library) {
                VirtualFile root;
                if (module == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider$1.addSupport must not be null");
                }
                if (model == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider$1.addSupport must not be null");
                }
                VirtualFile[] roots = model.getContentRoots();
                if (roots.length == 0) {
                    root = module.getModuleFile().getParent();
                    model.addContentEntry(root);
                } else {
                    root = roots[0];
                }
                new MavenModuleBuilderHelper(new MavenId("groupId", module.getName(), "1.0-SNAPSHOT"), null, null, false, false, null, "Add Maven Support").configure(model.getProject(), root, true);
            }
        };
        if (frameworkSupportConfigurable == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider.createConfigurable must not return null");
        }
        return frameworkSupportConfigurable;
    }

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider.isEnabledForModuleBuilder must not be null");
        }
        return false;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider.isSupportAlreadyAdded must not be null");
        }
        return MavenProjectsManager.getInstance(module.getProject()).isMavenizedModule(module);
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider.isEnabledForModuleType must not be null");
        }
        return moduleType.equals((Object)StdModuleTypes.JAVA);
    }

    public Icon getIcon() {
        return MavenIcons.MAVEN_ICON;
    }
}

