/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.SimpleProjectComponent;

public class MavenRehighlighter
extends SimpleProjectComponent {
    protected MavenRehighlighter(Project project) {
        super(project);
    }

    public void initComponent() {
        MavenProjectsManager m = MavenProjectsManager.getInstance(this.myProject);
        m.addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject);
            }

            @Override
            public void scheduledImportsChanged() {
            }
        });
        m.addProjectsTreeListener(new MavenProjectsTree.ListenerAdapter(){

            @Override
            public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted, Object message) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject);
            }

            @Override
            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, org.apache.maven.project.MavenProject nativeMavenProject, Object message) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject);
            }

            @Override
            public void pluginsResolved(MavenProject project) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject);
            }

            @Override
            public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, Object message) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject);
            }

            @Override
            public void artifactsDownloaded(MavenProject project) {
                MavenRehighlighter.rehighlight(MavenRehighlighter.this.myProject);
            }
        });
    }

    public static void rehighlight(final Project project) {
        MavenUtil.invokeLater(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
                        DaemonCodeAnalyzer.getInstance((Project)project).restart();
                    }
                });
            }
        });
    }
}

