/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import java.io.Serializable;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;

public class MavenRemoteRepository
implements Serializable {
    private String myId;
    private String myName;
    private String myUrl;
    private String myLayout;
    private Policy myReleasesPolicy;
    private Policy mySnapshotsPolicy;

    protected MavenRemoteRepository() {
    }

    public MavenRemoteRepository(Repository repository) {
        this.myId = repository.getId();
        this.myName = repository.getName();
        this.myUrl = repository.getUrl();
        this.myLayout = repository.getLayout();
        if (repository.getReleases() != null) {
            this.myReleasesPolicy = new Policy(repository.getReleases());
        }
        if (repository.getSnapshots() != null) {
            this.mySnapshotsPolicy = new Policy(repository.getSnapshots());
        }
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public String getLayout() {
        return this.myLayout;
    }

    public Policy getReleasesPolicy() {
        return this.myReleasesPolicy;
    }

    public Policy getSnapshotsPolicy() {
        return this.mySnapshotsPolicy;
    }

    public Repository toRepository() {
        Repository result = new Repository();
        result.setId(this.myId);
        result.setName(this.myName);
        result.setUrl(this.myUrl);
        result.setLayout(this.myLayout);
        if (this.myReleasesPolicy != null) {
            result.setReleases(this.myReleasesPolicy.toRepositoryPolicy());
        }
        if (this.mySnapshotsPolicy != null) {
            result.setSnapshots(this.mySnapshotsPolicy.toRepositoryPolicy());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRemoteRepository that = (MavenRemoteRepository)o;
        return !(this.myId != null ? !this.myId.equals(that.myId) : that.myId != null);
    }

    public int hashCode() {
        return this.myId != null ? this.myId.hashCode() : 0;
    }

    public static class Policy
    implements Serializable {
        private boolean myEnabled;
        private String myUpdatePolicy;
        private String myChecksumPolicy;

        protected Policy() {
        }

        public Policy(RepositoryPolicy policy) {
            this.myEnabled = policy.isEnabled();
            this.myUpdatePolicy = policy.getUpdatePolicy();
            this.myChecksumPolicy = policy.getChecksumPolicy();
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public String getUpdatePolicy() {
            return this.myUpdatePolicy;
        }

        public String getChecksumPolicy() {
            return this.myChecksumPolicy;
        }

        public RepositoryPolicy toRepositoryPolicy() {
            RepositoryPolicy result = new RepositoryPolicy();
            result.setEnabled(this.myEnabled);
            result.setUpdatePolicy(this.myUpdatePolicy);
            result.setChecksumPolicy(this.myChecksumPolicy);
            return result;
        }
    }
}

