/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactNode;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenResource;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Path;

public class MavenProject {
    private final VirtualFile myFile;
    private volatile State myState = new State();

    public static MavenProject read(DataInputStream in) throws IOException {
        String path = in.readUTF();
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return null;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
        ObjectInputStream os = new ObjectInputStream(bs);
        try {
            MavenProject result = new MavenProject(file);
            result.myState = (State)os.readObject();
            MavenProject mavenProject = result;
            return mavenProject;
        }
        catch (ClassNotFoundException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
        finally {
            os.close();
            bs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.getPath());
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bs);
        try {
            os.writeObject(this.myState);
            byte[] bytes = bs.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }
        finally {
            os.close();
            bs.close();
        }
    }

    public MavenProject(VirtualFile file) {
        this.myFile = file;
    }

    private MavenProjectChanges set(MavenProjectReaderResult readerResult, boolean updateLastReadStamp, boolean resetArtifacts, boolean resetProfiles) {
        State newState = this.myState.clone();
        if (updateLastReadStamp) {
            ++newState.myLastReadStamp;
        }
        org.apache.maven.project.MavenProject nativeMavenProject = readerResult.nativeMavenProject;
        newState.myReadingProblems = readerResult.readingProblems;
        newState.myLocalRepository = readerResult.localRepository;
        Collection<Profile> activeProfiles = MavenProject.collectActivateProfiles(nativeMavenProject);
        newState.myActiveProfilesIds = MavenProject.collectProfilesIds(activeProfiles);
        Model model = nativeMavenProject.getModel();
        newState.myMavenId = new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion());
        Parent parent = model.getParent();
        newState.myParentId = parent != null ? new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()) : null;
        newState.myPackaging = model.getPackaging();
        newState.myName = model.getName();
        Build build = model.getBuild();
        newState.myFinalName = build.getFinalName();
        newState.myDefaultGoal = build.getDefaultGoal();
        newState.myBuildDirectory = build.getDirectory();
        newState.myOutputDirectory = build.getOutputDirectory();
        newState.myTestOutputDirectory = build.getTestOutputDirectory();
        MavenProject.doSetFolders(newState, readerResult);
        newState.myFilters = build.getFilters() == null ? Collections.EMPTY_LIST : build.getFilters();
        newState.myProperties = model.getProperties() != null ? model.getProperties() : new Properties();
        MavenProject.doSetResolvedAttributes(newState, readerResult, resetArtifacts);
        newState.myModulesPathsAndNames = MavenProject.collectModulePathsAndNames(model, this.getDirectory(), activeProfiles);
        Collection<String> newProfiles = MavenProject.collectProfilesIds(model.getProfiles());
        if (resetProfiles || newState.myProfilesIds == null) {
            newState.myProfilesIds = newProfiles;
        } else {
            THashSet mergedProfiles = new THashSet(newState.myProfilesIds);
            mergedProfiles.addAll(newProfiles);
            newState.myProfilesIds = new ArrayList<String>((Collection<String>)mergedProfiles);
        }
        newState.myStrippedMavenModel = MavenUtil.cloneObject(model);
        MavenUtil.stripDown(newState.myStrippedMavenModel);
        return this.setState(newState);
    }

    private MavenProjectChanges setState(State newState) {
        MavenProjectChanges changes = this.myState.getChanges(newState);
        this.myState = newState;
        return changes;
    }

    private static void doSetResolvedAttributes(State state, MavenProjectReaderResult readerResult, boolean reset) {
        org.apache.maven.project.MavenProject nativeMavenProject = readerResult.nativeMavenProject;
        Model model = nativeMavenProject.getModel();
        THashSet newUnresolvedArtifacts = new THashSet();
        LinkedHashSet<MavenRemoteRepository> newRepositories = new LinkedHashSet<MavenRemoteRepository>();
        LinkedHashSet<MavenArtifact> newDependencies = new LinkedHashSet<MavenArtifact>();
        LinkedHashSet<MavenPlugin> newPlugins = new LinkedHashSet<MavenPlugin>();
        LinkedHashSet<MavenArtifact> newExtensions = new LinkedHashSet<MavenArtifact>();
        if (!reset) {
            if (state.myUnresolvedArtifactIds != null) {
                newUnresolvedArtifacts.addAll(state.myUnresolvedArtifactIds);
            }
            if (state.myRemoteRepositories != null) {
                newRepositories.addAll(state.myRemoteRepositories);
            }
            if (state.myDependencies != null) {
                newDependencies.addAll(state.myDependencies);
            }
            if (state.myPlugins != null) {
                newPlugins.addAll(state.myPlugins);
            }
            if (state.myExtensions != null) {
                newExtensions.addAll(state.myExtensions);
            }
        }
        newUnresolvedArtifacts.addAll(readerResult.unresolvedArtifactIds);
        newRepositories.addAll(MavenProject.convertRepositories(model.getRepositories()));
        newDependencies.addAll(MavenProject.convertArtifacts(nativeMavenProject.getArtifacts(), state.myLocalRepository));
        newPlugins.addAll(MavenProject.collectPlugins(readerResult.settings, model));
        newExtensions.addAll(MavenProject.convertArtifacts(nativeMavenProject.getExtensionArtifacts(), state.myLocalRepository));
        state.myUnresolvedArtifactIds = newUnresolvedArtifacts;
        state.myRemoteRepositories = new ArrayList<MavenRemoteRepository>(newRepositories);
        state.myDependencies = new ArrayList<MavenArtifact>(newDependencies);
        state.myPlugins = new ArrayList<MavenPlugin>(newPlugins);
        state.myExtensions = new ArrayList<MavenArtifact>(newExtensions);
    }

    private MavenProjectChanges setFolders(MavenProjectReaderResult readerResult) {
        State newState = this.myState.clone();
        MavenProject.doSetFolders(newState, readerResult);
        return this.setState(newState);
    }

    private static void doSetFolders(State newState, MavenProjectReaderResult readerResult) {
        org.apache.maven.project.MavenProject nativeMavenProject = readerResult.nativeMavenProject;
        newState.mySources = new ArrayList<String>(nativeMavenProject.getCompileSourceRoots());
        newState.myTestSources = new ArrayList<String>(nativeMavenProject.getTestCompileSourceRoots());
        newState.myResources = MavenProject.convertResources(nativeMavenProject.getResources());
        newState.myTestResources = MavenProject.convertResources(nativeMavenProject.getTestResources());
    }

    private static List<MavenResource> convertResources(List<Resource> resources) {
        if (resources == null) {
            return new ArrayList<MavenResource>();
        }
        ArrayList<MavenResource> result = new ArrayList<MavenResource>(resources.size());
        for (Resource each : resources) {
            result.add(new MavenResource(each));
        }
        return result;
    }

    private static List<MavenRemoteRepository> convertRepositories(List<Repository> repositories) {
        if (repositories == null) {
            return new ArrayList<MavenRemoteRepository>();
        }
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(repositories.size());
        for (Repository each : repositories) {
            result.add(new MavenRemoteRepository(each));
        }
        return result;
    }

    private static List<MavenArtifact> convertArtifacts(Collection<Artifact> artifacts, File localRepository) {
        if (artifacts == null) {
            return new ArrayList<MavenArtifact>();
        }
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>(artifacts.size());
        for (Artifact each : artifacts) {
            result.add(new MavenArtifact(each, localRepository));
        }
        return result;
    }

    private static List<MavenPlugin> collectPlugins(MavenGeneralSettings settings, Model mavenModel) {
        ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
        THashSet pluginKeys = new THashSet();
        Build build = mavenModel.getBuild();
        MavenProject.doCollectPlugins(settings, (PluginContainer)build, false, result, (Set<String>)pluginKeys);
        if (build != null) {
            MavenProject.doCollectPlugins(settings, (PluginContainer)build.getPluginManagement(), true, result, (Set<String>)pluginKeys);
        }
        return result;
    }

    private static void doCollectPlugins(MavenGeneralSettings settings, PluginContainer container, boolean management, List<MavenPlugin> result, Set<String> pluginKeys) {
        if (container == null) {
            return;
        }
        List plugins = container.getPlugins();
        if (plugins == null) {
            return;
        }
        for (Plugin each : plugins) {
            String key = each.getGroupId() + ":" + each.getArtifactId();
            if (management && (!MavenProject.isDefaultPlugin(settings, each) || pluginKeys.contains(key))) continue;
            result.add(new MavenPlugin(each, management));
            pluginKeys.add(key);
        }
    }

    private static boolean isDefaultPlugin(MavenGeneralSettings settings, Plugin plugin) {
        return settings.isDefaultPlugin(plugin.getGroupId(), plugin.getArtifactId());
    }

    private static Map<String, String> collectModulePathsAndNames(Model mavenModel, String baseDir, Collection<Profile> activeProfiles) {
        String basePath = baseDir + "/";
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> each : MavenProject.collectModulesRelativePathsAndNames(mavenModel, activeProfiles).entrySet()) {
            result.put(new Path(basePath + each.getKey()).getPath(), each.getValue());
        }
        return result;
    }

    private static Map<String, String> collectModulesRelativePathsAndNames(Model mavenModel, Collection<Profile> activeProfiles) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        MavenProject.addModulesToList(mavenModel.getModules(), result);
        for (Profile profile : activeProfiles) {
            MavenProject.addModulesToList(profile.getModules(), result);
        }
        return result;
    }

    private static void addModulesToList(List moduleNames, LinkedHashMap<String, String> result) {
        for (String name : moduleNames) {
            if (name.trim().length() == 0) continue;
            String originalName = name;
            if (!(name = FileUtil.toSystemIndependentName((String)name)).endsWith("/")) {
                name = name + "/";
            }
            name = name + "pom.xml";
            result.put(name, originalName);
        }
    }

    private static Collection<Profile> collectActivateProfiles(org.apache.maven.project.MavenProject nativeMavenProject) {
        List activatedProfiles = nativeMavenProject.getActiveProfiles();
        return activatedProfiles == null ? Collections.emptySet() : activatedProfiles;
    }

    private static Collection<String> collectProfilesIds(Collection<Profile> profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        THashSet result = new THashSet(profiles.size());
        for (Profile each : profiles) {
            String id = each.getId();
            if (id == null) continue;
            result.add(id);
        }
        return result;
    }

    public long getLastReadStamp() {
        return this.myState.myLastReadStamp;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getPath() {
        String string = this.myFile.getPath();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenProject.getPath must not return null");
        }
        return string;
    }

    public String getDirectory() {
        return this.myFile.getParent().getPath();
    }

    public VirtualFile getDirectoryFile() {
        return this.myFile.getParent();
    }

    public VirtualFile getProfilesXmlFile() {
        return MavenUtil.findProfilesXmlFile(this.myFile);
    }

    public File getProfilesXmlIoFile() {
        return MavenUtil.getProfilesXmlIoFile(this.myFile);
    }

    public boolean hasReadingProblems() {
        return !this.myState.myReadingProblems.isEmpty();
    }

    public Collection<String> getActiveProfilesIds() {
        return this.myState.myActiveProfilesIds;
    }

    public String getName() {
        return this.myState.myName;
    }

    public String getDisplayName() {
        State state = this.myState;
        if (StringUtil.isEmptyOrSpaces((String)state.myName)) {
            return state.myMavenId.getArtifactId();
        }
        return state.myName;
    }

    public Model getMavenModel() {
        return this.myState.myStrippedMavenModel;
    }

    public MavenId getMavenId() {
        return this.myState.myMavenId;
    }

    public MavenId getParentId() {
        return this.myState.myParentId;
    }

    public String getPackaging() {
        return this.myState.myPackaging;
    }

    public String getFinalName() {
        return this.myState.myFinalName;
    }

    public String getDefaultGoal() {
        return this.myState.myDefaultGoal;
    }

    public String getBuildDirectory() {
        return this.myState.myBuildDirectory;
    }

    public String getGeneratedSourcesDirectory() {
        return this.getBuildDirectory() + "/generated-sources";
    }

    public String getOutputDirectory() {
        return this.myState.myOutputDirectory;
    }

    public String getTestOutputDirectory() {
        return this.myState.myTestOutputDirectory;
    }

    public List<String> getSources() {
        return this.myState.mySources;
    }

    public List<String> getTestSources() {
        return this.myState.myTestSources;
    }

    public List<MavenResource> getResources() {
        return this.myState.myResources;
    }

    public List<MavenResource> getTestResources() {
        return this.myState.myTestResources;
    }

    public List<String> getFilters() {
        return this.myState.myFilters;
    }

    public MavenProjectChanges read(MavenGeneralSettings generalSettings, Collection<String> profiles, MavenProjectReader reader, MavenProjectReaderProjectLocator locator) {
        return this.set(reader.readProject(generalSettings, this.myFile, profiles, locator), true, false, true);
    }

    public Pair<MavenProjectChanges, org.apache.maven.project.MavenProject> resolve(MavenGeneralSettings generalSettings, MavenEmbedderWrapper embedder, MavenProjectReader reader, MavenProjectReaderProjectLocator locator) throws MavenProcessCanceledException {
        MavenProjectReaderResult result = reader.resolveProject(generalSettings, embedder, this.getFile(), this.getActiveProfilesIds(), locator);
        MavenProjectChanges changes = this.set(result, false, result.readingProblems.isEmpty(), false);
        for (MavenImporter eachImporter : this.getSuitableImporters()) {
            eachImporter.resolve(this, result.nativeMavenProject, embedder);
        }
        return Pair.create((Object)changes, (Object)result.nativeMavenProject);
    }

    public Pair<Boolean, MavenProjectChanges> resolveFolders(MavenEmbedderWrapper embedder, MavenGeneralSettings generalSettings, MavenImportingSettings importingSettings, MavenProjectReader reader, MavenConsole console) throws MavenProcessCanceledException {
        MavenProjectReaderResult result = reader.generateSources(embedder, generalSettings, importingSettings, this.getFile(), this.getActiveProfilesIds(), console);
        if (result == null || !result.readingProblems.isEmpty()) {
            return Pair.create((Object)false, (Object)MavenProjectChanges.NONE);
        }
        MavenProjectChanges changes = this.setFolders(result);
        return Pair.create((Object)true, (Object)changes);
    }

    public boolean isAggregator() {
        return "pom".equals(this.getPackaging()) || !this.getModulePaths().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProjectProblem> getProblems() {
        State state = this.myState;
        if (state.myProblemsCache == null) {
            State state2 = state;
            synchronized (state2) {
                if (state.myProblemsCache == null) {
                    state.myProblemsCache = MavenProject.collectProblems(this.myFile, state);
                }
            }
        }
        return state.myProblemsCache;
    }

    private static List<MavenProjectProblem> collectProblems(VirtualFile file, State state) {
        ArrayList<MavenProjectProblem> result = new ArrayList<MavenProjectProblem>();
        MavenProject.validateParent(file, state, result);
        result.addAll(state.myReadingProblems);
        for (Map.Entry<String, String> each : state.myModulesPathsAndNames.entrySet()) {
            if (LocalFileSystem.getInstance().findFileByPath(each.getKey()) != null) continue;
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.moduleNotFound", each.getValue())));
        }
        MavenProject.validateDependencies(file, state, result);
        MavenProject.validateExtensions(file, state, result);
        MavenProject.validatePlugins(file, state, result);
        return result;
    }

    private static void validateParent(VirtualFile file, State state, List<MavenProjectProblem> result) {
        if (!MavenProject.isParentResolved(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.parentNotFound", state.myParentId)));
        }
    }

    private static void validateDependencies(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedDependencies(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedDependency", each.getDisplayStringWithType())));
        }
    }

    private static void validateExtensions(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedExtensions(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedExtension", each.getDisplayStringSimple())));
        }
    }

    private static void validatePlugins(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenPlugin each : MavenProject.getUnresolvedPlugins(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedPlugin", each)));
        }
    }

    private static MavenProjectProblem createDependencyProblem(VirtualFile file, String description) {
        return new MavenProjectProblem(file, description, MavenProjectProblem.ProblemType.DEPENDENCY);
    }

    private static boolean isParentResolved(State state) {
        return !state.myUnresolvedArtifactIds.contains(state.myParentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedDependencies(State state) {
        if (state.myUnresolvedDependenciesCache == null) {
            State state2 = state;
            synchronized (state2) {
                if (state.myUnresolvedDependenciesCache == null) {
                    ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                    for (MavenArtifact each : state.myDependencies) {
                        if (each.isResolved()) continue;
                        result.add(each);
                    }
                    state.myUnresolvedDependenciesCache = result;
                }
            }
        }
        return state.myUnresolvedDependenciesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedExtensions(State state) {
        if (state.myUnresolvedExtensionsCache == null) {
            State state2 = state;
            synchronized (state2) {
                if (state.myUnresolvedExtensionsCache == null) {
                    ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                    for (MavenArtifact each : state.myExtensions) {
                        if (!state.myUnresolvedArtifactIds.contains(each.getMavenId()) || MavenProject.pomFileExists(state.myLocalRepository, each)) continue;
                        result.add(each);
                    }
                    state.myUnresolvedExtensionsCache = result;
                }
            }
        }
        return state.myUnresolvedExtensionsCache;
    }

    private static boolean pomFileExists(File localRepository, MavenArtifact artifact) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, artifact.getMavenId(), "pom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenPlugin> getUnresolvedPlugins(State state) {
        if (state.myUnresolvedPluginsCache == null) {
            State state2 = state;
            synchronized (state2) {
                if (state.myUnresolvedPluginsCache == null) {
                    ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
                    for (MavenPlugin each : MavenProject.getDeclaredPlugins(state)) {
                        if (MavenArtifactUtil.hasArtifactFile(state.myLocalRepository, each.getMavenId())) continue;
                        result.add(each);
                    }
                    state.myUnresolvedPluginsCache = result;
                }
            }
        }
        return state.myUnresolvedPluginsCache;
    }

    public List<VirtualFile> getExistingModuleFiles() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Set<String> pathsInStack = this.getModulePaths();
        for (String each : pathsInStack) {
            VirtualFile f = fs.findFileByPath(each);
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    public Set<String> getModulePaths() {
        return this.getModulesPathsAndNames().keySet();
    }

    public Map<String, String> getModulesPathsAndNames() {
        return this.myState.myModulesPathsAndNames;
    }

    public Collection<String> getProfilesIds() {
        return this.myState.myProfilesIds;
    }

    public List<MavenArtifact> getDependencies() {
        return this.myState.myDependencies;
    }

    public List<MavenArtifactNode> getDependenciesNodes() {
        return MavenProject.buildDependenciesNodes(this.myState.myDependencies);
    }

    private static List<MavenArtifactNode> buildDependenciesNodes(List<MavenArtifact> artifacts) {
        ArrayList<MavenArtifactNode> result = new ArrayList<MavenArtifactNode>();
        block0: for (MavenArtifact each : artifacts) {
            List<MavenArtifactNode> currentScope = result;
            for (String eachKey : each.getTrail()) {
                MavenArtifactNode node = MavenProject.findNodeFor(eachKey, currentScope, true);
                if (node == null) {
                    node = MavenProject.findNodeFor(eachKey, result, false);
                    if (node == null) {
                        MavenArtifact artifact = MavenProject.findArtifactFor(eachKey, artifacts);
                        if (artifact == null) continue block0;
                        node = new MavenArtifactNode(artifact, new ArrayList<MavenArtifactNode>());
                    }
                    currentScope.add(node);
                }
                currentScope = node.getDependencies();
            }
        }
        return result;
    }

    private static MavenArtifactNode findNodeFor(String artifactKey, Collection<MavenArtifactNode> nodes, boolean strict) {
        for (MavenArtifactNode each : nodes) {
            if (!each.getArtifact().getDisplayStringWithTypeAndClassifier().equals(artifactKey)) continue;
            return each;
        }
        if (strict) {
            return null;
        }
        for (MavenArtifactNode each : nodes) {
            MavenArtifactNode result = MavenProject.findNodeFor(artifactKey, each.getDependencies(), strict);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static MavenArtifact findArtifactFor(String artifactKey, Collection<MavenArtifact> artifacts) {
        for (MavenArtifact each : artifacts) {
            if (!each.getDisplayStringWithTypeAndClassifier().equals(artifactKey)) continue;
            return each;
        }
        return null;
    }

    public boolean isSupportedDependency(MavenArtifact artifact) {
        String t = artifact.getType();
        if ("jar".equalsIgnoreCase(t) || "test-jar".equalsIgnoreCase(t) || "ejb".equalsIgnoreCase(t) || "ejb-client".equalsIgnoreCase(t)) {
            return true;
        }
        for (MavenImporter each : this.getSuitableImporters()) {
            if (!each.isSupportedDependency(artifact)) continue;
            return true;
        }
        return false;
    }

    public void addDependency(MavenArtifact dependency) {
        this.addDependency(dependency, false);
    }

    public void addDependency(MavenArtifact dependency, boolean toBegin) {
        State state = this.myState;
        ArrayList<MavenArtifact> dependenciesCopy = new ArrayList<MavenArtifact>(state.myDependencies.size() + 1);
        if (toBegin) {
            dependenciesCopy.add(dependency);
            dependenciesCopy.addAll(state.myDependencies);
        } else {
            dependenciesCopy.addAll(state.myDependencies);
            dependenciesCopy.add(dependency);
        }
        state.myDependencies = dependenciesCopy;
    }

    public List<MavenArtifact> findDependencies(MavenProject depProject) {
        return this.findDependencies(depProject.getMavenId());
    }

    public List<MavenArtifact> findDependencies(MavenId id) {
        SmartList result = new SmartList();
        for (MavenArtifact each : this.getDependencies()) {
            if (!each.getMavenId().equals(id)) continue;
            result.add(each);
        }
        return result;
    }

    public List<MavenArtifact> findDependencies(String groupId, String artifactId) {
        SmartList result = new SmartList();
        for (MavenArtifact each : this.getDependencies()) {
            if (!each.getMavenId().equals(groupId, artifactId)) continue;
            result.add(each);
        }
        return result;
    }

    public boolean hasUnresolvedArtifacts() {
        State state = this.myState;
        return !MavenProject.isParentResolved(state) || !MavenProject.getUnresolvedDependencies(state).isEmpty() || !MavenProject.getUnresolvedExtensions(state).isEmpty();
    }

    public boolean hasUnresolvedPlugins() {
        return !MavenProject.getUnresolvedPlugins(this.myState).isEmpty();
    }

    public List<MavenPlugin> getPlugins() {
        return this.myState.myPlugins;
    }

    public List<MavenPlugin> getDeclaredPlugins() {
        return MavenProject.getDeclaredPlugins(this.myState);
    }

    private static List<MavenPlugin> getDeclaredPlugins(State state) {
        return ContainerUtil.findAll(state.myPlugins, (Condition)new Condition<MavenPlugin>(){

            public boolean value(MavenPlugin mavenPlugin) {
                return !mavenPlugin.isDefault();
            }
        });
    }

    @Nullable
    public Element getPluginConfiguration(String groupId, String artifactId) {
        return this.doGetPluginOrGoalConfiguration(groupId, artifactId, null);
    }

    @Nullable
    public Element getPluginGoalConfiguration(String groupId, String artifactId, String goal) {
        return this.doGetPluginOrGoalConfiguration(groupId, artifactId, goal);
    }

    @Nullable
    private Element doGetPluginOrGoalConfiguration(String groupId, String artifactId, @Nullable String goalOrNull) {
        MavenPlugin plugin = this.findPlugin(groupId, artifactId);
        if (plugin == null) {
            return null;
        }
        Element configElement = null;
        if (goalOrNull == null) {
            configElement = plugin.getConfigurationElement();
        } else {
            for (MavenPlugin.Execution each : plugin.getExecutions()) {
                if (!each.getGoals().contains(goalOrNull)) continue;
                configElement = each.getConfigurationElement();
            }
        }
        return configElement;
    }

    @Nullable
    public MavenPlugin findPlugin(String groupId, String artifactId) {
        for (MavenPlugin each : this.getPlugins()) {
            if (!each.getMavenId().equals(groupId, artifactId)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public String getSourceLevel() {
        return this.getCompilerLevel("source");
    }

    @Nullable
    public String getTargetLevel() {
        return this.getCompilerLevel("target");
    }

    private String getCompilerLevel(String level) {
        String result = MavenJDOMUtil.findChildValueByPath(this.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin"), level);
        return MavenProject.normalizeCompilerLevel(result);
    }

    public static String normalizeCompilerLevel(String level) {
        if (level == null) {
            return null;
        }
        return CompilerLevelTable.table.get(level);
    }

    public Properties getProperties() {
        return this.myState.myProperties;
    }

    public File getLocalRepository() {
        return this.myState.myLocalRepository;
    }

    public List<MavenRemoteRepository> getRemoteRepositories() {
        return this.myState.myRemoteRepositories;
    }

    public List<MavenImporter> getSuitableImporters() {
        return MavenImporter.getSuitableImporters(this);
    }

    public Pair<String, String> getClassifierAndExtension(MavenArtifact artifact, MavenExtraArtifactType type) {
        for (MavenImporter each : this.getSuitableImporters()) {
            Pair<String, String> result = each.getExtraArtifactClassifierAndExtension(artifact, type);
            if (result == null) continue;
            return result;
        }
        return Pair.create((Object)type.getDefaultClassifier(), (Object)type.getDefaultExtension());
    }

    public String toString() {
        return this.getMavenId().toString();
    }

    private static class State
    implements Cloneable,
    Serializable {
        long myLastReadStamp = 0L;
        MavenId myMavenId;
        MavenId myParentId;
        String myPackaging;
        String myName;
        String myFinalName;
        String myDefaultGoal;
        String myBuildDirectory;
        String myOutputDirectory;
        String myTestOutputDirectory;
        List<String> mySources;
        List<String> myTestSources;
        List<MavenResource> myResources;
        List<MavenResource> myTestResources;
        List<String> myFilters;
        Properties myProperties;
        List<MavenPlugin> myPlugins;
        List<MavenArtifact> myExtensions;
        List<MavenArtifact> myDependencies;
        Map<String, String> myModulesPathsAndNames;
        Collection<String> myProfilesIds;
        Model myStrippedMavenModel;
        List<MavenRemoteRepository> myRemoteRepositories;
        Collection<String> myActiveProfilesIds;
        Collection<MavenProjectProblem> myReadingProblems;
        Set<MavenId> myUnresolvedArtifactIds;
        File myLocalRepository;
        volatile List<MavenProjectProblem> myProblemsCache;
        volatile List<MavenArtifact> myUnresolvedDependenciesCache;
        volatile List<MavenPlugin> myUnresolvedPluginsCache;
        volatile List<MavenArtifact> myUnresolvedExtensionsCache;

        private State() {
        }

        public State clone() {
            try {
                State result = (State)super.clone();
                result.myProblemsCache = null;
                result.myUnresolvedDependenciesCache = null;
                result.myUnresolvedPluginsCache = null;
                result.myUnresolvedExtensionsCache = null;
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public MavenProjectChanges getChanges(State other) {
            if (this.myLastReadStamp == 0L) {
                return MavenProjectChanges.ALL;
            }
            MavenProjectChanges result = new MavenProjectChanges();
            result.packaging = result.packaging | !Comparing.equal((String)this.myPackaging, (String)other.myPackaging);
            result.output = result.output | !Comparing.equal((String)this.myFinalName, (String)other.myFinalName);
            result.output = result.output | !Comparing.equal((String)this.myBuildDirectory, (String)other.myBuildDirectory);
            result.output = result.output | !Comparing.equal((String)this.myOutputDirectory, (String)other.myOutputDirectory);
            result.output = result.output | !Comparing.equal((String)this.myTestOutputDirectory, (String)other.myTestOutputDirectory);
            result.sources = result.sources | !Comparing.equal(this.mySources, other.mySources);
            result.sources = result.sources | !Comparing.equal(this.myTestSources, other.myTestSources);
            result.sources = result.sources | !Comparing.equal(this.myResources, other.myResources);
            result.sources = result.sources | !Comparing.equal(this.myTestResources, other.myTestResources);
            boolean repositoryChanged = !Comparing.equal((Object)this.myLocalRepository, (Object)other.myLocalRepository);
            result.dependencies |= repositoryChanged;
            result.dependencies = result.dependencies | !Comparing.equal(this.myDependencies, other.myDependencies);
            result.plugins |= repositoryChanged;
            result.plugins = result.plugins | !Comparing.equal(this.myPlugins, other.myPlugins);
            return result;
        }
    }

    private static class CompilerLevelTable {
        public static Map<String, String> table = new THashMap();

        private CompilerLevelTable() {
        }

        static {
            table.put("1.1", "1.1");
            table.put("1.2", "1.2");
            table.put("1.3", "1.3");
            table.put("1.4", "1.4");
            table.put("1.5", "1.5");
            table.put("5", "1.5");
            table.put("1.6", "1.6");
            table.put("1.7", "1.7");
            table.put("7", "1.7");
        }
    }
}

