/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.embedder.MavenExecutionOptions;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class MavenGeneralSettings
implements Cloneable {
    private boolean workOffline = false;
    private String mavenHome = "";
    private String mavenSettingsFile = "";
    private String localRepository = "";
    private boolean printErrorStackTraces = false;
    private boolean usePluginRegistry = false;
    private boolean nonRecursive = false;
    private MavenExecutionOptions.LoggingLevel outputLevel = MavenExecutionOptions.LoggingLevel.INFO;
    private MavenExecutionOptions.ChecksumPolicy checksumPolicy = MavenExecutionOptions.ChecksumPolicy.FAIL;
    private MavenExecutionOptions.FailureMode failureBehavior = MavenExecutionOptions.FailureMode.FAST;
    private MavenExecutionOptions.SnapshotUpdatePolicy snapshotUpdatePolicy = MavenExecutionOptions.SnapshotUpdatePolicy.ALWAYS_UPDATE;
    private MavenExecutionOptions.PluginUpdatePolicy pluginUpdatePolicy = MavenExecutionOptions.PluginUpdatePolicy.DO_NOT_UPDATE;
    private volatile File myEffectiveLocalRepositoryCache;
    private volatile Set<String> myDefaultPluginsCache;
    private List<Listener> myListeners = ContainerUtil.createEmptyCOWList();

    @NotNull
    public MavenExecutionOptions.PluginUpdatePolicy getPluginUpdatePolicy() {
        MavenExecutionOptions.PluginUpdatePolicy pluginUpdatePolicy = this.pluginUpdatePolicy;
        if (pluginUpdatePolicy == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getPluginUpdatePolicy must not return null");
        }
        return pluginUpdatePolicy;
    }

    public void setPluginUpdatePolicy(MavenExecutionOptions.PluginUpdatePolicy value) {
        if (value == null) {
            return;
        }
        this.pluginUpdatePolicy = value;
    }

    @NotNull
    public MavenExecutionOptions.ChecksumPolicy getChecksumPolicy() {
        MavenExecutionOptions.ChecksumPolicy checksumPolicy = this.checksumPolicy;
        if (checksumPolicy == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getChecksumPolicy must not return null");
        }
        return checksumPolicy;
    }

    public void setChecksumPolicy(MavenExecutionOptions.ChecksumPolicy value) {
        if (value == null) {
            return;
        }
        this.checksumPolicy = value;
    }

    @NotNull
    public MavenExecutionOptions.FailureMode getFailureBehavior() {
        MavenExecutionOptions.FailureMode failureMode = this.failureBehavior;
        if (failureMode == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getFailureBehavior must not return null");
        }
        return failureMode;
    }

    public void setFailureBehavior(MavenExecutionOptions.FailureMode value) {
        if (value == null) {
            return;
        }
        this.failureBehavior = value;
    }

    @NotNull
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.outputLevel;
        if (loggingLevel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getLoggingLevel must not return null");
        }
        return loggingLevel;
    }

    public void setOutputLevel(MavenExecutionOptions.LoggingLevel value) {
        if (value == null) {
            return;
        }
        this.outputLevel = value;
    }

    @NotNull
    public MavenExecutionOptions.SnapshotUpdatePolicy getSnapshotUpdatePolicy() {
        MavenExecutionOptions.SnapshotUpdatePolicy snapshotUpdatePolicy = this.snapshotUpdatePolicy;
        if (snapshotUpdatePolicy == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getSnapshotUpdatePolicy must not return null");
        }
        return snapshotUpdatePolicy;
    }

    public void setSnapshotUpdatePolicy(MavenExecutionOptions.SnapshotUpdatePolicy value) {
        if (value == null) {
            return;
        }
        this.snapshotUpdatePolicy = value;
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public void setWorkOffline(boolean workOffline) {
        this.workOffline = workOffline;
    }

    @NotNull
    public String getLocalRepository() {
        String string = this.localRepository;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getLocalRepository must not return null");
        }
        return string;
    }

    public File getEffectiveLocalRepository() {
        File result = this.myEffectiveLocalRepositoryCache;
        if (result != null) {
            return result;
        }
        this.myEffectiveLocalRepositoryCache = result = MavenEmbedderFactory.resolveLocalRepository(this.mavenHome, this.mavenSettingsFile, this.localRepository);
        return result;
    }

    public void setLocalRepository(@Nullable String localRepository) {
        if (localRepository != null && !Comparing.equal((String)this.localRepository, (String)localRepository)) {
            this.localRepository = localRepository;
            this.localRepositoryChanged();
        }
    }

    @NotNull
    public String getMavenHome() {
        String string = this.mavenHome;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getMavenHome must not return null");
        }
        return string;
    }

    public void setMavenHome(@NotNull String mavenHome) {
        if (mavenHome == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/project/MavenGeneralSettings.setMavenHome must not be null");
        }
        if (!Comparing.equal((String)this.mavenHome, (String)mavenHome)) {
            this.mavenHome = mavenHome;
            this.myDefaultPluginsCache = null;
            this.pathsChanged();
        }
    }

    @Nullable
    public File getEffectiveMavenHome() {
        return MavenEmbedderFactory.resolveMavenHomeDirectory(this.getMavenHome());
    }

    @NotNull
    public String getMavenSettingsFile() {
        String string = this.mavenSettingsFile;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getMavenSettingsFile must not return null");
        }
        return string;
    }

    public void setMavenSettingsFile(@Nullable String mavenSettingsFile) {
        if (mavenSettingsFile != null && !Comparing.equal((String)this.mavenSettingsFile, (String)mavenSettingsFile)) {
            this.mavenSettingsFile = mavenSettingsFile;
            this.pathsChanged();
        }
    }

    public void localRepositoryChanged() {
        this.pathsChanged();
    }

    private void pathsChanged() {
        this.myEffectiveLocalRepositoryCache = null;
        this.fidePathsChanged();
    }

    @Nullable
    public File getEffectiveUserSettingsIoFile() {
        return MavenEmbedderFactory.resolveUserSettingsFile(this.getMavenSettingsFile());
    }

    @Nullable
    public File getEffectiveGlobalSettingsIoFile() {
        return MavenEmbedderFactory.resolveGlobalSettingsFile(this.getMavenHome());
    }

    @Nullable
    public VirtualFile getEffectiveUserSettingsFile() {
        File file = this.getEffectiveUserSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public List<VirtualFile> getEffectiveSettingsFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(2);
        VirtualFile file = this.getEffectiveUserSettingsFile();
        if (file != null) {
            result.add(file);
        }
        if ((file = this.getEffectiveGlobalSettingsFile()) != null) {
            result.add(file);
        }
        return result;
    }

    @Nullable
    public VirtualFile getEffectiveGlobalSettingsFile() {
        File file = this.getEffectiveGlobalSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @NotNull
    public VirtualFile getEffectiveSuperPom() {
        VirtualFile virtualFile = MavenEmbedderFactory.resolveSuperPomFile(this.getMavenHome());
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenGeneralSettings.getEffectiveSuperPom must not return null");
        }
        return virtualFile;
    }

    public boolean isDefaultPlugin(String groupId, String artifactId) {
        return this.getDefaultPlugins().contains(groupId + ":" + artifactId);
    }

    private Set<String> getDefaultPlugins() {
        THashSet result = this.myDefaultPluginsCache;
        if (result != null) {
            return result;
        }
        result = new THashSet();
        Element superProject = MavenJDOMUtil.read(this.getEffectiveSuperPom(), null);
        for (Element each : MavenJDOMUtil.findChildrenByPath(superProject, "build.pluginManagement.plugins", "plugin")) {
            String groupId = MavenJDOMUtil.findChildValueByPath(each, "groupId", "org.apache.maven.plugins");
            String artifactId = MavenJDOMUtil.findChildValueByPath(each, "artifactId", null);
            result.add(groupId + ":" + artifactId);
        }
        this.myDefaultPluginsCache = result;
        return result;
    }

    public boolean isPrintErrorStackTraces() {
        return this.printErrorStackTraces;
    }

    public void setPrintErrorStackTraces(boolean value) {
        this.printErrorStackTraces = value;
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        this.usePluginRegistry = usePluginRegistry;
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean nonRecursive) {
        this.nonRecursive = nonRecursive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenGeneralSettings that = (MavenGeneralSettings)o;
        if (this.nonRecursive != that.nonRecursive) {
            return false;
        }
        if (this.outputLevel != that.outputLevel) {
            return false;
        }
        if (this.pluginUpdatePolicy != that.pluginUpdatePolicy) {
            return false;
        }
        if (this.snapshotUpdatePolicy != that.snapshotUpdatePolicy) {
            return false;
        }
        if (this.printErrorStackTraces != that.printErrorStackTraces) {
            return false;
        }
        if (this.usePluginRegistry != that.usePluginRegistry) {
            return false;
        }
        if (this.workOffline != that.workOffline) {
            return false;
        }
        if (!this.checksumPolicy.equals((Object)that.checksumPolicy)) {
            return false;
        }
        if (!this.failureBehavior.equals((Object)that.failureBehavior)) {
            return false;
        }
        if (!this.localRepository.equals(that.localRepository)) {
            return false;
        }
        if (!this.mavenHome.equals(that.mavenHome)) {
            return false;
        }
        return this.mavenSettingsFile.equals(that.mavenSettingsFile);
    }

    public int hashCode() {
        int result = this.workOffline ? 1 : 0;
        result = 31 * result + this.mavenHome.hashCode();
        result = 31 * result + this.mavenSettingsFile.hashCode();
        result = 31 * result + this.localRepository.hashCode();
        result = 31 * result + (this.printErrorStackTraces ? 1 : 0);
        result = 31 * result + (this.usePluginRegistry ? 1 : 0);
        result = 31 * result + (this.nonRecursive ? 1 : 0);
        result = 31 * result + this.outputLevel.hashCode();
        result = 31 * result + this.checksumPolicy.hashCode();
        result = 31 * result + this.failureBehavior.hashCode();
        result = 31 * result + this.pluginUpdatePolicy.hashCode();
        result = 31 * result + this.snapshotUpdatePolicy.hashCode();
        return result;
    }

    public MavenGeneralSettings clone() {
        try {
            MavenGeneralSettings result = (MavenGeneralSettings)super.clone();
            result.myListeners = ContainerUtil.createEmptyCOWList();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fidePathsChanged() {
        for (Listener each : this.myListeners) {
            each.pathsChanged();
        }
    }

    public static interface Listener {
        public void pathsChanged();
    }
}

