/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.indices.ArchetypeInfo;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenArchetypesProvider;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenIndicesManager
implements ApplicationComponent {
    private static final String ELEMENT_ARCHETYPES = "archetypes";
    private static final String ELEMENT_ARCHETYPE = "archetype";
    private static final String ELEMENT_GROUP_ID = "groupId";
    private static final String ELEMENT_ARTIFACT_ID = "artifactId";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_REPOSITORY = "repository";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String LOCAL_REPOSITORY_ID = "local";
    private volatile File myTestIndicesDir;
    private volatile MavenEmbedderWrapper myEmbedder;
    private volatile MavenIndices myIndices;
    private final Object myUpdatingIndicesLock = new Object();
    private final List<MavenIndex> myWaitingIndices = new ArrayList<MavenIndex>();
    private volatile MavenIndex myUpdatingIndex;
    private final BackgroundTaskQueue myUpdatingQueue = new BackgroundTaskQueue(IndicesBundle.message("maven.indices.updating", new Object[0]));
    private volatile List<ArchetypeInfo> myUserArchetypes = new ArrayList<ArchetypeInfo>();

    public static MavenIndicesManager getInstance() {
        return (MavenIndicesManager)ApplicationManager.getApplication().getComponent(MavenIndicesManager.class);
    }

    @NotNull
    public String getComponentName() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/indices/MavenIndicesManager.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
    }

    public void setTestIndexDir(File indicesDir) {
        this.myTestIndicesDir = indicesDir;
    }

    private synchronized MavenIndices getIndicesObject() {
        this.ensureInitialized();
        return this.myIndices;
    }

    private synchronized void ensureInitialized() {
        if (this.myIndices != null) {
            return;
        }
        MavenGeneralSettings defaultSettings = new MavenGeneralSettings();
        this.myEmbedder = MavenEmbedderFactory.createEmbedder(defaultSettings);
        this.myIndices = new MavenIndices(this.myEmbedder, this.getIndicesDir(), new MavenIndex.IndexListener(){

            @Override
            public void indexIsBroken(MavenIndex index) {
                MavenIndicesManager.this.scheduleUpdate(null, Collections.singletonList(index), false);
            }
        });
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                MavenIndicesManager.this.doShutdown();
            }
        });
        this.loadUserArchetypes();
    }

    private File getIndicesDir() {
        return this.myTestIndicesDir == null ? MavenUtil.getPluginSystemDir("Indices") : this.myTestIndicesDir;
    }

    public void disposeComponent() {
        this.doShutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            FileUtil.delete((File)this.getIndicesDir());
        }
    }

    private synchronized void doShutdown() {
        if (this.myIndices != null) {
            try {
                this.myIndices.close();
            }
            catch (Exception e) {
                MavenLog.LOG.error("", (Throwable)e);
            }
            this.myIndices = null;
        }
        if (this.myEmbedder != null) {
            try {
                this.myEmbedder.release();
            }
            catch (Exception e) {
                MavenLog.LOG.error("", (Throwable)e);
            }
            this.myEmbedder = null;
        }
    }

    public void doShutdownInTests() {
        this.doShutdown();
    }

    public List<MavenIndex> getIndices() {
        return this.getIndicesObject().getIndices();
    }

    public synchronized List<MavenIndex> ensureIndicesExist(Project project, File localRepository, Collection<Pair<String, String>> remoteRepositoriesIdsAndUrls) {
        LinkedHashSet<MavenIndex> result = new LinkedHashSet<MavenIndex>();
        MavenIndices indicesObjectCache = this.getIndicesObject();
        try {
            MavenIndex localIndex = indicesObjectCache.add(LOCAL_REPOSITORY_ID, localRepository.getPath(), MavenIndex.Kind.LOCAL);
            result.add(localIndex);
            if (localIndex.getUpdateTimestamp() == -1L) {
                this.scheduleUpdate(project, Collections.singletonList(localIndex));
            }
        }
        catch (MavenIndexException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        for (Pair<String, String> eachIdAndUrl : remoteRepositoriesIdsAndUrls) {
            try {
                result.add(indicesObjectCache.add((String)eachIdAndUrl.first, (String)eachIdAndUrl.second, MavenIndex.Kind.REMOTE));
            }
            catch (MavenIndexException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return new ArrayList<MavenIndex>(result);
    }

    public void addArtifact(File artifactFile, String name) {
        String repositoryPath = this.getRepositoryUrl(artifactFile, name);
        MavenIndex index = this.getIndicesObject().find(LOCAL_REPOSITORY_ID, repositoryPath, MavenIndex.Kind.LOCAL);
        if (index != null) {
            index.addArtifact(artifactFile);
        }
    }

    private String getRepositoryUrl(File artifactFile, String name) {
        List<String> parts = this.getArtifactParts(name);
        File result = artifactFile;
        for (int i = 0; i < parts.size(); ++i) {
            result = result.getParentFile();
        }
        return result.getPath();
    }

    private List<String> getArtifactParts(String name) {
        return StringUtil.split((String)name, (String)"/");
    }

    public void scheduleUpdate(Project project, List<MavenIndex> indices) {
        this.scheduleUpdate(project, indices, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate(final Project projectOrNull, List<MavenIndex> indices, final boolean fullUpdate) {
        final ArrayList<MavenIndex> toSchedule = new ArrayList<MavenIndex>();
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            for (MavenIndex each : indices) {
                if (this.myWaitingIndices.contains(each)) continue;
                toSchedule.add(each);
            }
            this.myWaitingIndices.addAll(toSchedule);
        }
        this.myUpdatingQueue.run(new Task.Backgroundable(projectOrNull, IndicesBundle.message("maven.indices.updating", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/indices/MavenIndicesManager$3.run must not be null");
                }
                MavenIndicesManager.this.doUpdateIndices(projectOrNull, toSchedule, fullUpdate, indicator);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateIndices(final Project projectOrNull, List<MavenIndex> indices, boolean fullUpdate, ProgressIndicator indicator) {
        Object object;
        ArrayList<MavenIndex> remainingWaiting = new ArrayList<MavenIndex>(indices);
        try {
            for (MavenIndex each : indices) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText(IndicesBundle.message("maven.indices.updating.index", each.getRepositoryId(), each.getRepositoryPathOrUrl()));
                object = this.myUpdatingIndicesLock;
                synchronized (object) {
                    remainingWaiting.remove(each);
                    this.myWaitingIndices.remove(each);
                    this.myUpdatingIndex = each;
                }
                try {
                    MavenEmbedderWrapper embedderToUse = null;
                    if (fullUpdate && (embedderToUse = (MavenEmbedderWrapper)new ReadAction<MavenEmbedderWrapper>(){

                        protected void run(Result<MavenEmbedderWrapper> result) throws Throwable {
                            if (!projectOrNull.isDisposed()) {
                                MavenGeneralSettings settings = MavenProjectsManager.getInstance(projectOrNull).getGeneralSettings();
                                result.setResult((Object)MavenEmbedderFactory.createEmbedder(settings));
                            }
                        }
                    }.execute().getResultObject()) == null) {
                        throw new ProcessCanceledException();
                    }
                    try {
                        this.getIndicesObject().updateOrRepair(each, embedderToUse, fullUpdate, indicator);
                    }
                    finally {
                        if (embedderToUse != null) {
                            embedderToUse.release();
                        }
                    }
                    this.scheduleRehighlightAllPoms(projectOrNull);
                }
                finally {
                    object = this.myUpdatingIndicesLock;
                    synchronized (object) {
                        this.myUpdatingIndex = null;
                    }
                }
            }
        }
        catch (ProcessCanceledException ignore) {
            Object object2 = this.myUpdatingIndicesLock;
            synchronized (object2) {
                this.myWaitingIndices.removeAll(remainingWaiting);
            }
        }
        finally {
            object = this.myUpdatingIndicesLock;
            synchronized (object) {
                this.myWaitingIndices.removeAll(remainingWaiting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexUpdatingState getUpdatingState(MavenIndex index) {
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            if (this.myUpdatingIndex == index) {
                return IndexUpdatingState.UPDATING;
            }
            if (this.myWaitingIndices.contains(index)) {
                return IndexUpdatingState.WAITING;
            }
            return IndexUpdatingState.IDLE;
        }
    }

    private void scheduleRehighlightAllPoms(Project projectOrNull) {
        if (projectOrNull == null) {
            return;
        }
        MavenRehighlighter.rehighlight(projectOrNull);
    }

    public synchronized Set<ArchetypeInfo> getArchetypes() {
        this.ensureInitialized();
        THashSet result = new THashSet();
        result.addAll(this.getArchetypesFrom("internal-catalog"));
        result.addAll(this.getArchetypesFrom("nexus"));
        result.addAll(this.myUserArchetypes);
        for (MavenArchetypesProvider each : (MavenArchetypesProvider[])Extensions.getExtensions(MavenArchetypesProvider.EP_NAME)) {
            result.addAll(each.getArchetypes());
        }
        return result;
    }

    public synchronized void addArchetype(ArchetypeInfo archetype) {
        this.ensureInitialized();
        this.myUserArchetypes.add(archetype);
        this.saveUserArchetypes();
    }

    private void loadUserArchetypes() {
        try {
            File file = this.getUserArchetypesFile();
            if (!file.exists()) {
                return;
            }
            Document doc = JDOMUtil.loadDocument((File)file);
            Element root = doc.getRootElement();
            if (root == null) {
                return;
            }
            ArrayList<ArchetypeInfo> result = new ArrayList<ArchetypeInfo>();
            for (Element each : root.getChildren(ELEMENT_ARCHETYPE)) {
                String groupId = each.getAttributeValue(ELEMENT_GROUP_ID);
                String artifactId = each.getAttributeValue(ELEMENT_ARTIFACT_ID);
                String version = each.getAttributeValue(ELEMENT_VERSION);
                String repository = each.getAttributeValue(ELEMENT_REPOSITORY);
                String description = each.getAttributeValue(ELEMENT_DESCRIPTION);
                if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId) || StringUtil.isEmptyOrSpaces((String)version)) continue;
                result.add(new ArchetypeInfo(groupId, artifactId, version, repository, description));
            }
            this.myUserArchetypes = result;
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        catch (JDOMException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    private void saveUserArchetypes() {
        Element root = new Element(ELEMENT_ARCHETYPES);
        for (ArchetypeInfo each : this.myUserArchetypes) {
            Element childElement = new Element(ELEMENT_ARCHETYPE);
            childElement.setAttribute(ELEMENT_GROUP_ID, each.groupId);
            childElement.setAttribute(ELEMENT_ARTIFACT_ID, each.artifactId);
            childElement.setAttribute(ELEMENT_VERSION, each.version);
            if (each.repository != null) {
                childElement.setAttribute(ELEMENT_REPOSITORY, each.repository);
            }
            if (each.description != null) {
                childElement.setAttribute(ELEMENT_DESCRIPTION, each.description);
            }
            root.addContent(childElement);
        }
        try {
            File file = this.getUserArchetypesFile();
            file.getParentFile().mkdirs();
            JDOMUtil.writeDocument((Document)new Document(root), (File)file, (String)"\n");
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    private File getUserArchetypesFile() {
        return new File(this.getIndicesDir(), "UserArchetypes.xml");
    }

    private List<ArchetypeInfo> getArchetypesFrom(String roleHint) {
        try {
            ArchetypeDataSource source = this.myEmbedder.getComponent(ArchetypeDataSource.class, roleHint);
            ArchetypeCatalog catalog = source.getArchetypeCatalog(new Properties());
            ArrayList<ArchetypeInfo> result = new ArrayList<ArchetypeInfo>();
            for (Archetype each : catalog.getArchetypes()) {
                result.add(new ArchetypeInfo(each));
            }
            return result;
        }
        catch (ArchetypeDataSourceException e) {
            MavenLog.LOG.warn((Throwable)e);
            return Collections.emptyList();
        }
    }

    public static enum IndexUpdatingState {
        IDLE,
        WAITING,
        UPDATING;

    }
}

