/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenGoalLocation;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenRunConfigurationType
implements LocatableConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory((ConfigurationType)this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            throw new UnsupportedOperationException();
        }

        public RunConfiguration createTemplateConfiguration(Project project, RunManager runManager) {
            return new MavenRunConfiguration(project, this, "");
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            if (providerID == CompileStepBeforeRun.ID) {
                task.setEnabled(false);
            }
        }
    };
    private static final Icon ICON = IconLoader.getIcon((String)"/images/phase.png");
    private static final int MAX_NAME_LENGTH = 40;

    MavenRunConfigurationType() {
    }

    public String getDisplayName() {
        return RunnerBundle.message("maven.run.configuration.name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return RunnerBundle.message("maven.run.configuration.description", new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NonNls
    @NotNull
    public String getId() {
        if ("MavenRunConfiguration" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenRunConfigurationType.getId must not return null");
        }
        return "MavenRunConfiguration";
    }

    public static String generateName(Project project, MavenRunnerParameters runnerParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String name = MavenRunConfigurationType.getMavenProjectName(project, runnerParameters);
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            stringBuilder.append(name);
            stringBuilder.append(" ");
        }
        stringBuilder.append("[");
        MavenRunConfigurationType.listGoals(stringBuilder, runnerParameters.getGoals());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static void listGoals(StringBuilder stringBuilder, List<String> goals) {
        int index = 0;
        for (String goal : goals) {
            if (index != 0) {
                if (stringBuilder.length() + goal.length() < 40) {
                    stringBuilder.append(",");
                } else {
                    stringBuilder.append("...");
                    break;
                }
            }
            stringBuilder.append(goal);
            ++index;
        }
    }

    private static String getMavenProjectName(Project project, MavenRunnerParameters runnerParameters) {
        MavenProject mavenProject;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = localFileSystem.findFileByPath(runnerParameters.getPomFilePath());
        if (virtualFile != null && (mavenProject = MavenProjectsManager.getInstance(project).findProject(virtualFile)) != null && !StringUtil.isEmptyOrSpaces((String)mavenProject.getMavenId().getArtifactId())) {
            return mavenProject.getMavenId().getArtifactId();
        }
        return null;
    }

    public RunnerAndConfigurationSettings createConfigurationByLocation(Location l) {
        MavenRunnerParameters params = MavenRunConfigurationType.createBuildParameters(l);
        if (params == null) {
            return null;
        }
        return MavenRunConfigurationType.createRunnerAndConfigurationSettings(null, null, params, l.getProject());
    }

    public boolean isConfigurationByLocation(RunConfiguration configuration, Location location) {
        return configuration instanceof MavenRunConfiguration && ((MavenRunConfiguration)configuration).getRunnerParameters().equals(MavenRunConfigurationType.createBuildParameters(location));
    }

    private static MavenRunnerParameters createBuildParameters(Location l) {
        if (!(l instanceof MavenGoalLocation)) {
            return null;
        }
        VirtualFile f = ((PsiFile)l.getPsiElement()).getVirtualFile();
        List<String> goals = ((MavenGoalLocation)l).getGoals();
        Collection<String> profiles = MavenProjectsManager.getInstance(l.getProject()).getExplicitProfiles();
        return new MavenRunnerParameters(true, f.getParent().getPath(), goals, profiles);
    }

    public static void runConfiguration(Project project, MavenRunnerParameters params, DataContext dataContext, @Nullable ProgramRunner.Callback callback) {
        MavenGeneralSettings settings = MavenProjectsManager.getInstance(project).getGeneralSettings();
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(project).getState();
        MavenRunConfigurationType.runConfiguration(project, params, settings, runnerSettings, dataContext, callback);
    }

    public static void runConfiguration(Project project, MavenRunnerParameters params, MavenGeneralSettings settings, MavenRunnerSettings runnerSettings, DataContext context, @Nullable ProgramRunner.Callback callback) {
        RunnerAndConfigurationSettings configSettings = MavenRunConfigurationType.createRunnerAndConfigurationSettings(settings, runnerSettings, params, project);
        ProgramRunner runner = RunnerRegistry.getInstance().findRunnerById(DefaultRunExecutor.EXECUTOR_ID);
        ExecutionEnvironment env = new ExecutionEnvironment(runner, configSettings, context);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        try {
            runner.execute(executor, env, callback);
        }
        catch (ExecutionException e) {
            MavenUtil.showError(project, "Failed to execute Maven goal", e);
        }
    }

    private static RunnerAndConfigurationSettings createRunnerAndConfigurationSettings(MavenGeneralSettings generalSettings, MavenRunnerSettings runnerSettings, MavenRunnerParameters params, Project project) {
        MavenRunConfigurationType type = (MavenRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(MavenRunConfigurationType.class);
        RunnerAndConfigurationSettingsImpl settings = RunManagerEx.getInstanceEx((Project)project).createConfiguration(MavenRunConfigurationType.generateName(project, params), type.myFactory);
        MavenRunConfiguration runConfiguration = (MavenRunConfiguration)settings.getConfiguration();
        runConfiguration.setRunnerParameters(params);
        if (generalSettings != null) {
            runConfiguration.setGeneralSettings(generalSettings);
        }
        if (runnerSettings != null) {
            runConfiguration.setRunnerSettings(runnerSettings);
        }
        return settings;
    }
}

