/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReference;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenPropertyPsiReferenceProvider
extends PsiReferenceProvider {
    private final boolean myFiltered;

    public MavenPropertyPsiReferenceProvider(boolean filtered) {
        this.myFiltered = filtered;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider.getReferencesByElement must not be null");
        }
        if (this.myFiltered) {
            if (!MavenDomUtil.isFiltererResourceFile(element)) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            } else {
                psiReferenceArray = MavenPropertyPsiReferenceProvider.getReferences(element, element.getText(), 0, true, false);
                if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
            }
        }
        psiReferenceArray = MavenPropertyPsiReferenceProvider.getReferences(element, false);
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider.getReferencesByElement must not return null");
    }

    public static PsiReference[] getReferences(PsiElement element, boolean isSoft) {
        String text = ElementManipulators.getValueText((PsiElement)element);
        int textStart = ElementManipulators.getValueTextRange((PsiElement)element).getStartOffset();
        return MavenPropertyPsiReferenceProvider.getReferences(element, text, textStart, false, isSoft);
    }

    private static PsiReference[] getReferences(PsiElement element, String text, int textStart, boolean isFiltered, boolean isSoft) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return PsiReference.EMPTY_ARRAY;
        }
        MavenProject mavenProject = MavenDomUtil.findContainingProject(element);
        if (mavenProject == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<MavenFilteredPropertyPsiReference> result = new ArrayList<MavenFilteredPropertyPsiReference>();
        Matcher matcher = MavenPropertyResolver.PATTERN.matcher(text);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            int from = textStart + matcher.start(1);
            TextRange range = TextRange.from((int)from, (int)propertyName.length());
            MavenPropertyPsiReference ref = isFiltered ? new MavenFilteredPropertyPsiReference(mavenProject, element, propertyName, range, isSoft) : new MavenPropertyPsiReference(mavenProject, element, propertyName, range, isSoft);
            result.add((MavenFilteredPropertyPsiReference)ref);
        }
        return result.toArray(new PsiReference[result.size()]);
    }
}

