/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ResolvingConverter;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomExtension;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public abstract class MavenArtifactCoordinatesConverter
extends ResolvingConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(this.getProject(context));
        return this.selectStrategy(context).isValid(id, manager, context) ? s : null;
    }

    protected abstract boolean doIsValid(MavenId var1, MavenProjectIndicesManager var2, ConvertContext var3);

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(this.getProject(context));
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        MavenDomShortArtifactCoordinates coordinates = MavenArtifactCoordinatesHelper.getCoordinates(context);
        Set<String> set = this.selectStrategy(context).getVariants(id, manager, coordinates);
        if (set == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter.getVariants must not return null");
        }
        return set;
    }

    protected abstract Set<String> doGetVariants(MavenId var1, MavenProjectIndicesManager var2);

    public PsiElement resolve(String o, ConvertContext context) {
        Project p = this.getProject(context);
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        PsiFile result = this.selectStrategy(context).resolve(p, id);
        return result != null ? result : super.resolve((Object)o, context);
    }

    private Project getProject(ConvertContext context) {
        return context.getFile().getProject();
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return this.selectStrategy(context).getContextName() + " '''" + MavenArtifactCoordinatesHelper.getId(context) + "''' not found";
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return (LocalQuickFix[])ArrayUtil.append((Object[])super.getQuickFixes(context), (Object)new MyUpdateIndicesFix());
    }

    private ConverterStrategy selectStrategy(ConvertContext context) {
        if (MavenDomUtil.getImmediateParent(context, MavenDomProjectModel.class) != null) {
            return new ProjectStrategy();
        }
        MavenDomParent parent = MavenDomUtil.getImmediateParent(context, MavenDomParent.class);
        if (parent != null) {
            return new ParentStrategy(parent);
        }
        MavenDomDependency dependency = MavenDomUtil.getImmediateParent(context, MavenDomDependency.class);
        if (dependency != null) {
            return new DependencyStrategy(dependency);
        }
        if (MavenDomUtil.getImmediateParent(context, MavenDomExclusion.class) != null) {
            return new ExclusionStrategy();
        }
        if (MavenDomUtil.getImmediateParent(context, MavenDomPlugin.class) != null) {
            return new PluginOrExtensionStrategy(true);
        }
        if (MavenDomUtil.getImmediateParent(context, MavenDomExtension.class) != null) {
            return new PluginOrExtensionStrategy(false);
        }
        return new ConverterStrategy();
    }

    private class PluginOrExtensionStrategy
    extends ConverterStrategy {
        private final boolean myPlugin;

        public PluginOrExtensionStrategy(boolean isPlugin) {
            this.myPlugin = isPlugin;
        }

        @Override
        public String getContextName() {
            return this.myPlugin ? "Plugin " : "Build Extension";
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                for (String each : MavenArtifactUtil.DEFAULT_GROUPS) {
                    if (!super.isValid(id = new MavenId(each, id.getArtifactId(), id.getVersion()), manager, context)) continue;
                    return true;
                }
                return false;
            }
            return super.isValid(id, manager, context);
        }

        @Override
        public Set<String> getVariants(MavenId id, MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                THashSet result = new THashSet();
                for (String each : this.getGroupIdVariants(manager, coordinates)) {
                    id = new MavenId(each, id.getArtifactId(), id.getVersion());
                    result.addAll(super.getVariants(id, manager, coordinates));
                }
                return result;
            }
            return super.getVariants(id, manager, coordinates);
        }

        private String[] getGroupIdVariants(MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            if (DomUtil.hasXml(coordinates.getGroupId())) {
                Set<String> strings = manager.getGroupIds();
                return ArrayUtil.toStringArray(strings);
            }
            return MavenArtifactUtil.DEFAULT_GROUPS;
        }

        @Override
        protected File makeLocalRepositoryFile(MavenId id, File localRepository) {
            return MavenArtifactUtil.getArtifactFile(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
        }
    }

    private class ExclusionStrategy
    extends ConverterStrategy {
        private ExclusionStrategy() {
        }

        @Override
        public PsiFile resolve(Project project, MavenId id) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return true;
        }
    }

    private class DependencyStrategy
    extends ConverterStrategy {
        private MavenDomDependency myDependency;

        public DependencyStrategy(MavenDomDependency dependency) {
            this.myDependency = dependency;
        }

        @Override
        public String getContextName() {
            return "Dependency";
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myDependency.getSystemPath().getValue();
        }

        @Override
        public Set<String> getVariants(MavenId id, MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                THashSet result = new THashSet();
                if (DomUtil.hasXml(coordinates.getGroupId())) {
                    for (String each : manager.getGroupIds()) {
                        id = new MavenId(each, id.getArtifactId(), id.getVersion());
                        result.addAll(super.getVariants(id, manager, coordinates));
                    }
                }
                return result;
            }
            return super.getVariants(id, manager, coordinates);
        }
    }

    private class ParentStrategy
    extends ConverterStrategy {
        private MavenDomParent myParent;

        public ParentStrategy(MavenDomParent parent) {
            this.myParent = parent;
        }

        @Override
        public String getContextName() {
            return "Project";
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myParent.getRelativePath().getValue();
        }
    }

    private class ProjectStrategy
    extends ConverterStrategy {
        private ProjectStrategy() {
        }

        @Override
        public PsiFile resolve(Project project, MavenId id) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return true;
        }
    }

    private class ConverterStrategy {
        private ConverterStrategy() {
        }

        public String getContextName() {
            return "Artifact";
        }

        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return MavenArtifactCoordinatesConverter.this.doIsValid(id, manager, context) || this.resolveBySpecifiedPath() != null;
        }

        public Set<String> getVariants(MavenId id, MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            return MavenArtifactCoordinatesConverter.this.doGetVariants(id, manager);
        }

        public PsiFile resolve(Project project, MavenId id) {
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiFile result = this.resolveBySpecifiedPath();
            if (result != null) {
                return result;
            }
            result = this.resolveInProjects(id, projectsManager, psiManager);
            if (result != null) {
                return result;
            }
            return this.resolveInLocalRepository(id, projectsManager, psiManager);
        }

        protected PsiFile resolveBySpecifiedPath() {
            return null;
        }

        private PsiFile resolveInProjects(MavenId id, MavenProjectsManager projectsManager, PsiManager psiManager) {
            MavenProject project = projectsManager.findProject(id);
            return project == null ? null : psiManager.findFile(project.getFile());
        }

        private PsiFile resolveInLocalRepository(MavenId id, MavenProjectsManager projectsManager, PsiManager psiManager) {
            File file = this.makeLocalRepositoryFile(id, projectsManager.getLocalRepository());
            if (file == null) {
                return null;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (virtualFile == null) {
                return null;
            }
            return psiManager.findFile(virtualFile);
        }

        protected File makeLocalRepositoryFile(MavenId id, File localRepostory) {
            String relPath = ("" + id.getGroupId()).replace(".", "/");
            relPath = relPath + "/" + id.getArtifactId();
            relPath = relPath + "/" + id.getVersion();
            relPath = relPath + "/" + id.getArtifactId() + "-" + id.getVersion() + ".pom";
            return new File(localRepostory, relPath);
        }
    }

    private class MyUpdateIndicesFix
    implements LocalQuickFix {
        private MyUpdateIndicesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix.getFamilyName must not return null");
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = MavenDomBundle.message("fix.update.indices", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix.getName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix.applyFix must not be null");
            }
            MavenProjectIndicesManager.getInstance(project).scheduleUpdateAll();
        }
    }
}

