/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IfsUtil {
    private static final Key<Long> TIMESTAMP_KEY = Key.create((String)"Image.timeStamp");
    private static final Key<String> FORMAT_KEY = Key.create((String)"Image.format");
    private static final Key<SoftReference<BufferedImage>> BUFFERED_IMAGE_REF_KEY = Key.create((String)"Image.bufferedImage");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean refresh(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/vfs/IfsUtil.refresh must not be null");
        }
        Long loadedTimeStamp = (Long)file.getUserData(TIMESTAMP_KEY);
        SoftReference imageRef = (SoftReference)file.getUserData(BUFFERED_IMAGE_REF_KEY);
        if (loadedTimeStamp == null || loadedTimeStamp.longValue() != file.getTimeStamp() || imageRef == null || imageRef.get() == null) {
            try {
                byte[] content = file.contentsToByteArray();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content, 0, content.length);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                try {
                    Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
                    if (imageReaders.hasNext()) {
                        ImageReader imageReader = imageReaders.next();
                        try {
                            file.putUserData(FORMAT_KEY, (Object)imageReader.getFormatName());
                            ImageReadParam param = imageReader.getDefaultReadParam();
                            imageReader.setInput(imageInputStream, true, true);
                            int minIndex = imageReader.getMinIndex();
                            BufferedImage image = imageReader.read(minIndex, param);
                            file.putUserData(BUFFERED_IMAGE_REF_KEY, (Object)new SoftReference((Object)image));
                            boolean bl = true;
                            imageReader.dispose();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            imageReader.dispose();
                            throw throwable;
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    imageInputStream.close();
                }
            }
            finally {
                file.putUserData(TIMESTAMP_KEY, (Object)file.getTimeStamp());
            }
        }
        return false;
    }

    @Nullable
    public static BufferedImage getImage(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/vfs/IfsUtil.getImage must not be null");
        }
        IfsUtil.refresh(file);
        SoftReference imageRef = (SoftReference)file.getUserData(BUFFERED_IMAGE_REF_KEY);
        return imageRef != null ? (BufferedImage)imageRef.get() : null;
    }

    @Nullable
    public static String getFormat(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/vfs/IfsUtil.getFormat must not be null");
        }
        IfsUtil.refresh(file);
        return (String)file.getUserData(FORMAT_KEY);
    }

    public static String getReferencePath(Project project, VirtualFile file) {
        LogicalRoot logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)project).findLogicalRoot(file);
        if (logicalRoot != null) {
            return IfsUtil.getRelativePath(file, logicalRoot.getVirtualFile());
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
        if (sourceRoot != null) {
            return IfsUtil.getRelativePath(file, sourceRoot);
        }
        VirtualFile root = fileIndex.getContentRootForFile(file);
        if (root != null) {
            return IfsUtil.getRelativePath(file, root);
        }
        return file.getPath();
    }

    private static String getRelativePath(VirtualFile file, VirtualFile root) {
        if (root.equals(file)) {
            return file.getPath();
        }
        return "/" + VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
    }
}

