/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.xml.XmlFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlIconProvider
extends IconProvider
implements DumbAware {
    private static final Icon ourXsdIcon = IconLoader.getIcon((String)"/fileTypes/xsdFile.png");
    private static final Icon ourWsdlIcon = IconLoader.getIcon((String)"/fileTypes/wsdlFile.png");
    @NonNls
    private static final String XSD_FILE_EXTENSION = "xsd";
    @NonNls
    private static final String WSDL_FILE_EXTENSION = "wsdl";

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int _flags) {
        VirtualFile vf;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlIconProvider.getIcon must not be null");
        }
        if (element instanceof XmlFile && (vf = ((XmlFile)element).getVirtualFile()) != null) {
            String extension = vf.getExtension();
            if (XSD_FILE_EXTENSION.equals(extension)) {
                return ElementBase.createLayeredIcon((Icon)ourXsdIcon, (int)ElementBase.transformFlags((PsiElement)element, (int)_flags));
            }
            if (WSDL_FILE_EXTENSION.equals(extension)) {
                return ElementBase.createLayeredIcon((Icon)ourWsdlIcon, (int)ElementBase.transformFlags((PsiElement)element, (int)_flags));
            }
        }
        return null;
    }
}

