/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import com.intellij.xml.util.XmlIdContributor;
import com.intellij.xml.util.XmlRefCountHolder;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlDuplicatedIdInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlDuplicatedIdInspection.buildVisitor must not be null");
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                if (value.getTextRange().isEmpty()) {
                    return;
                }
                PsiFile file = value.getContainingFile();
                if (file instanceof XmlFile) {
                    XmlRefCountHolder refHolder = XmlRefCountHolder.getInstance((XmlFile)file);
                    if (refHolder == null) {
                        return;
                    }
                    PsiElement parent = value.getParent();
                    if (!(parent instanceof XmlAttribute)) {
                        return;
                    }
                    XmlTag tag = ((XmlAttribute)parent).getParent();
                    if (tag == null) {
                        return;
                    }
                    if (refHolder.isValidatable(tag.getParent()) && refHolder.isDuplicateIdAttributeValue(value)) {
                        holder.registerProblem((PsiElement)value, XmlErrorMessages.message("duplicate.id.reference", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                    }
                    String idRef = XmlHighlightVisitor.getUnquotedValue(value, tag);
                    if (tag instanceof HtmlTag) {
                        idRef = idRef.toLowerCase();
                    }
                    if (XmlUtil.isSimpleXmlAttributeValue(idRef, value) && refHolder.isIdReferenceValue(value)) {
                        boolean hasIdDeclaration = refHolder.hasIdDeclaration(idRef);
                        if (!hasIdDeclaration && tag instanceof HtmlTag) {
                            hasIdDeclaration = refHolder.hasIdDeclaration(StringUtil.stripQuotesAroundValue((String)value.getText()));
                        }
                        if (!hasIdDeclaration) {
                            for (XmlIdContributor contributor : (XmlIdContributor[])Extensions.getExtensions(XmlIdContributor.EP_NAME)) {
                                if (!contributor.suppressExistingIdValidation((XmlFile)file)) continue;
                                return;
                            }
                            FileViewProvider viewProvider = tag.getContainingFile().getViewProvider();
                            if (viewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
                                holder.registerProblem((PsiElement)value, XmlErrorMessages.message("invalid.id.reference", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{new XmlDeclareIdInCommentAction(idRef)});
                            } else {
                                holder.registerProblem((PsiElement)value, XmlErrorMessages.message("invalid.id.reference", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                            }
                        }
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XmlDuplicatedIdInspection.buildVisitor must not return null");
        }
        return xmlElementVisitor;
    }

    public boolean runForWholeFile() {
        return false;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XmlDuplicatedIdInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.group.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XmlDuplicatedIdInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.duplicate.id", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XmlDuplicatedIdInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("XmlDuplicatedId" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XmlDuplicatedIdInspection.getShortName must not return null");
        }
        return "XmlDuplicatedId";
    }
}

