/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class XsdTagNameBuilder
extends NanoXmlUtil.IXMLBuilderAdapter {
    private final Collection<String> myTagNames = new ArrayList<String>();
    private boolean myElementStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Collection<String> computeTagNames(InputStream is) {
        try {
            XsdTagNameBuilder builder = new XsdTagNameBuilder();
            NanoXmlUtil.parse((InputStream)is, (IXMLBuilder)builder);
            Collection<String> collection = builder.myTagNames;
            return collection;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    public static Collection<String> computeTagNames(VirtualFile file) {
        return (Collection)VfsUtil.processInputStream((VirtualFile)file, (Function)new NullableFunction<InputStream, Collection<String>>(){

            public Collection<String> fun(InputStream inputStream) {
                return XsdTagNameBuilder.computeTagNames(inputStream);
            }
        });
    }

    public void startElement(@NonNls String name, @NonNls String nsPrefix, @NonNls String nsURI, String systemID, int lineNr) throws Exception {
        this.myElementStarted = nsPrefix != null && nsURI.equals("http://www.w3.org/2001/XMLSchema") && name.equals("element");
    }

    public void addAttribute(@NonNls String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        if (this.myElementStarted && key.equals("name")) {
            this.myTagNames.add(value);
            this.myElementStarted = false;
        }
    }
}

