/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import com.intellij.xml.breadcrumbs.BreadcrumbsPsiItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsXmlWrapper
implements BreadcrumbsItemListener<BreadcrumbsPsiItem>,
Disposable {
    private final BreadcrumbsComponent<BreadcrumbsPsiItem> myComponent;
    private final Project myProject;
    private Editor myEditor;
    private final VirtualFile myFile;
    private boolean myUserCaretChange;
    private final MergingUpdateQueue myQueue;
    private final BreadcrumbsInfoProvider myInfoProvider;
    private final JPanel myWrapperPanel;

    public BreadcrumbsXmlWrapper(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper.<init> must not be null");
        }
        this.myEditor = editor;
        Project project = editor.getProject();
        assert (project != null);
        this.myProject = project;
        Document document = this.myEditor.getDocument();
        this.myFile = FileDocumentManager.getInstance().getFile(document);
        FileStatusManager manager = FileStatusManager.getInstance((Project)project);
        manager.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                if (BreadcrumbsXmlWrapper.this.myComponent != null) {
                    Font editorFont = BreadcrumbsXmlWrapper.this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
                    BreadcrumbsXmlWrapper.this.myComponent.setFont(editorFont.deriveFont(0, editorFont.getSize2D()));
                    BreadcrumbsXmlWrapper.this.updateCrumbs(BreadcrumbsXmlWrapper.this.myEditor.getCaretModel().getLogicalPosition());
                }
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$1.fileStatusChanged must not be null");
                }
            }
        }, (Disposable)this);
        this.myInfoProvider = BreadcrumbsXmlWrapper.findInfoProvider(this.findViewProvider());
        final CaretListener caretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                if (BreadcrumbsXmlWrapper.this.myUserCaretChange) {
                    BreadcrumbsXmlWrapper.this.myQueue.cancelAllUpdates();
                    BreadcrumbsXmlWrapper.this.myQueue.queue((Update)new MyUpdate(BreadcrumbsXmlWrapper.this, editor));
                }
                BreadcrumbsXmlWrapper.this.myUserCaretChange = true;
            }
        };
        editor.getCaretModel().addCaretListener(caretListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                editor.getCaretModel().removeCaretListener(caretListener);
            }
        });
        PomManager.getModel((Project)project).addModelListener(new PomModelListener(){

            public void modelChanged(PomModelEvent event) {
                PomChangeSet set = event.getChangeSet(event.getSource().getModelAspect(XmlAspect.class));
                if (set instanceof XmlChangeSet && BreadcrumbsXmlWrapper.this.myQueue != null) {
                    BreadcrumbsXmlWrapper.this.myQueue.cancelAllUpdates();
                    BreadcrumbsXmlWrapper.this.myQueue.queue((Update)new MyUpdate(BreadcrumbsXmlWrapper.this, editor));
                }
            }

            public boolean isAspectChangeInteresting(PomModelAspect aspect) {
                return aspect instanceof XmlAspect;
            }
        }, (Disposable)this);
        this.myComponent = new BreadcrumbsComponent();
        this.myComponent.addBreadcrumbsItemListener((BreadcrumbsItemListener)this);
        Font editorFont = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        this.myComponent.setFont(editorFont.deriveFont(0, editorFont.getSize2D()));
        final ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BreadcrumbsXmlWrapper.this.myQueue.cancelAllUpdates();
                BreadcrumbsXmlWrapper.this.myQueue.queue((Update)new MyUpdate(BreadcrumbsXmlWrapper.this, editor));
            }
        };
        this.myComponent.addComponentListener((ComponentListener)resizeListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                BreadcrumbsXmlWrapper.this.myComponent.removeComponentListener((ComponentListener)resizeListener);
            }
        });
        this.myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, this.myComponent);
        this.myQueue.queue((Update)new MyUpdate(this, editor));
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector(this.myComponent, (Activatable)this.myQueue));
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        this.myWrapperPanel = new JPanel();
        this.myWrapperPanel.setLayout(new BorderLayout());
        this.myWrapperPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 1, 0));
        this.myWrapperPanel.add((Component)this.myComponent, "Center");
    }

    private void moveEditorCaretTo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper.moveEditorCaretTo must not be null");
        }
        if (element.isValid()) {
            this.setUserCaretChange(false);
            this.myEditor.getCaretModel().moveToOffset(element.getTextOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Nullable
    private BreadcrumbsInfoProvider findProviderForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper.findProviderForElement must not be null");
        }
        BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.getInfoProvider(element.getLanguage());
        return provider == null ? this.myInfoProvider : provider;
    }

    private void setUserCaretChange(boolean userCaretChange) {
        this.myUserCaretChange = userCaretChange;
    }

    @Nullable
    private List<BreadcrumbsPsiItem> getLineElements(@NotNull LogicalPosition position) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper.getLineElements must not be null");
        }
        PsiElement element = this.findFirstBreadcrumbedElement(position);
        if (element == null) {
            return null;
        }
        LinkedList<BreadcrumbsPsiItem> result = new LinkedList<BreadcrumbsPsiItem>();
        while (element != null) {
            BreadcrumbsInfoProvider provider = this.findProviderForElement(element);
            if (provider != null && provider.acceptElement(element)) {
                result.addFirst(new BreadcrumbsPsiItem(element, provider));
            }
            element = provider != null ? provider.getParent(element) : element.getParent();
        }
        return result;
    }

    @Nullable
    private PsiElement findFirstBreadcrumbedElement(LogicalPosition position) {
        if (this.myFile == null || !this.myFile.isValid()) {
            return null;
        }
        int offset = this.myEditor.logicalPositionToOffset(position);
        PriorityQueue<PsiElement> leafs = new PriorityQueue<PsiElement>(3, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return o2.getTextRange().getStartOffset() - o1.getTextRange().getStartOffset();
            }
        });
        FileViewProvider viewProvider = this.findViewProvider();
        if (viewProvider == null) {
            return null;
        }
        for (Language language : viewProvider.getLanguages()) {
            ContainerUtil.addIfNotNull((Object)viewProvider.findElementAt(offset, language), leafs);
        }
        while (!leafs.isEmpty()) {
            PsiElement element = (PsiElement)leafs.remove();
            if (!element.isValid()) continue;
            BreadcrumbsInfoProvider provider = this.findProviderForElement(element);
            if (provider != null && provider.acceptElement(element)) {
                return element;
            }
            if (element instanceof PsiFile) continue;
            ContainerUtil.addIfNotNull((Object)element.getParent(), leafs);
        }
        return null;
    }

    @Nullable
    private FileViewProvider findViewProvider() {
        if (this.myFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)this.myProject).findViewProvider(this.myFile);
    }

    private void updateCrumbs(LogicalPosition position) {
        if (this.myFile != null && this.myEditor != null) {
            if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                return;
            }
            this.myComponent.setItems(this.getLineElements(position));
        }
    }

    @Nullable
    static BreadcrumbsInfoProvider findInfoProvider(@Nullable FileViewProvider viewProvider) {
        BreadcrumbsInfoProvider provider;
        block1: {
            Language language;
            Language baseLang;
            provider = null;
            if (viewProvider == null || (provider = BreadcrumbsXmlWrapper.getInfoProvider(baseLang = viewProvider.getBaseLanguage())) != null) break block1;
            Iterator i$ = viewProvider.getLanguages().iterator();
            while (i$.hasNext() && (provider = BreadcrumbsXmlWrapper.getInfoProvider(language = (Language)i$.next())) == null) {
            }
        }
        return provider;
    }

    public JComponent getComponent() {
        return this.myWrapperPanel;
    }

    public void itemSelected(@NotNull BreadcrumbsPsiItem item, int modifiers) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper.itemSelected must not be null");
        }
        PsiElement psiElement = item.getPsiElement();
        this.moveEditorCaretTo(psiElement);
        if ((modifiers & 1) == 1 || (modifiers & 4) == 4) {
            TextRange range = psiElement.getTextRange();
            this.myEditor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    public void dispose() {
        this.myEditor = null;
    }

    @Nullable
    private static BreadcrumbsInfoProvider getInfoProvider(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper.getInfoProvider must not be null");
        }
        for (BreadcrumbsInfoProvider provider : (BreadcrumbsInfoProvider[])Extensions.getExtensions((ExtensionPointName)BreadcrumbsInfoProvider.EP_NAME)) {
            for (Language language1 : provider.getLanguages()) {
                if (!language.isKindOf(language1)) continue;
                return provider;
            }
        }
        return null;
    }

    private class MyUpdate
    extends Update {
        private final BreadcrumbsXmlWrapper myBreadcrumbsComponent;
        private final Editor myEditor;

        public MyUpdate(@NotNull BreadcrumbsXmlWrapper c, Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$MyUpdate.<init> must not be null");
            }
            super((Object)c);
            this.myBreadcrumbsComponent = c;
            this.myEditor = editor;
        }

        public void run() {
            this.myBreadcrumbsComponent.updateCrumbs(this.myEditor.getCaretModel().getLogicalPosition());
        }

        public boolean canEat(Update update) {
            return true;
        }
    }
}

