/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageTreeNode
extends XDebuggerTreeNode {
    private boolean myEllipsis;

    private MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon) {
        this(tree, parent, message, attributes, icon, false);
    }

    private MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon, boolean ellipsis) {
        super(tree, parent, true);
        this.myEllipsis = ellipsis;
        this.setIcon(icon);
        this.myText.append(message, attributes);
    }

    protected MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, boolean leaf) {
        super(tree, parent, leaf);
        this.myEllipsis = false;
    }

    private MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, String infoMessage, String errorMessage) {
        super(tree, parent, true);
        this.myEllipsis = false;
    }

    @Override
    protected List<? extends TreeNode> getChildren() {
        return Collections.emptyList();
    }

    public boolean isEllipsis() {
        return this.myEllipsis;
    }

    @Override
    public List<? extends XDebuggerTreeNode> getLoadedChildren() {
        return null;
    }

    @Override
    public void clearChildren() {
    }

    public static MessageTreeNode createEllipsisNode(XDebuggerTree tree, XDebuggerTreeNode parent, int remaining) {
        String message = remaining == -1 ? "..." : XDebuggerBundle.message((String)"node.text.ellipsis.0.more.nodes.double.click.to.show", (Object[])new Object[]{remaining});
        return new MessageTreeNode(tree, parent, message, SimpleTextAttributes.REGULAR_ATTRIBUTES, null, true);
    }

    public static MessageTreeNode createMessageNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, @Nullable Icon icon) {
        return new MessageTreeNode(tree, parent, message, SimpleTextAttributes.REGULAR_ATTRIBUTES, icon);
    }

    public static MessageTreeNode createLoadingMessage(XDebuggerTree tree, XDebuggerTreeNode parent) {
        return new MessageTreeNode(tree, parent, XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES, null);
    }

    public static MessageTreeNode createEvaluatingMessage(XDebuggerTree tree, XDebuggerTreeNode parent, String message) {
        return new MessageTreeNode(tree, parent, message, XDebuggerUIConstants.EVALUATING_EXPRESSION_HIGHLIGHT_ATTRIBUTES, null);
    }

    public static MessageTreeNode createEvaluatingMessage(XDebuggerTree tree, XDebuggerTreeNode parent) {
        return new MessageTreeNode(tree, parent, XDebuggerUIConstants.EVALUATING_EXPRESSION_MESSAGE, XDebuggerUIConstants.EVALUATING_EXPRESSION_HIGHLIGHT_ATTRIBUTES, null);
    }

    public static MessageTreeNode createErrorMessage(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/MessageTreeNode.createErrorMessage must not be null");
        }
        return new MessageTreeNode(tree, parent, errorMessage, XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES, XDebuggerUIConstants.ERROR_MESSAGE_ICON);
    }

    public static MessageTreeNode createInfoMessage(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/nodes/MessageTreeNode.createInfoMessage must not be null");
        }
        return new MessageTreeNode(tree, parent, message, SimpleTextAttributes.REGULAR_ATTRIBUTES, XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
    }
}

