/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.ui.Messages;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SetValueInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final JPanel myEditorPanel;
    private final XValueModifier myModifier;
    private final XValueNodeImpl myValueNode;

    public SetValueInplaceEditor(XValueNodeImpl node, @NotNull String nodeName) {
        if (nodeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/SetValueInplaceEditor.<init> must not be null");
        }
        super(node, "setValue");
        this.myValueNode = node;
        this.myModifier = ((XValue)this.myValueNode.getValueContainer()).getModifier();
        this.myEditorPanel = new JPanel();
        this.myEditorPanel.setLayout(new BoxLayout(this.myEditorPanel, 0));
        SimpleColoredComponent nameLabel = new SimpleColoredComponent();
        nameLabel.setIcon(this.getNode().getIcon());
        nameLabel.append(nodeName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        this.myEditorPanel.add((Component)nameLabel);
        this.myEditorPanel.add(this.myExpressionEditor.getComponent());
        String value = this.myModifier != null ? this.myModifier.getInitialValueEditorText() : null;
        this.myExpressionEditor.setText(value != null ? value : "");
        this.myExpressionEditor.selectAll();
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myEditorPanel;
    }

    @Override
    public void doOKAction() {
        if (this.myModifier == null) {
            return;
        }
        this.myExpressionEditor.saveTextInHistory();
        final XDebuggerTreeState treeState = XDebuggerTreeState.saveState(this.myTree);
        this.myValueNode.setValueModificationStarted();
        this.myModifier.setValue(this.myExpressionEditor.getText(), new XValueModifier.XModificationCallback(){

            public void valueModified() {
                DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

                    @Override
                    public void run() {
                        SetValueInplaceEditor.this.myTree.rebuildAndRestore(treeState);
                    }
                });
            }

            public void errorOccurred(final @NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/SetValueInplaceEditor$1.errorOccurred must not be null");
                }
                DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

                    @Override
                    public void run() {
                        SetValueInplaceEditor.this.myTree.rebuildAndRestore(treeState);
                        Messages.showErrorDialog((Component)((Object)SetValueInplaceEditor.this.myTree), (String)errorMessage);
                    }
                });
            }

            public void errorOccured(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/SetValueInplaceEditor$1.errorOccured must not be null");
                }
                this.errorOccurred(errorMessage);
            }
        });
        super.doOKAction();
    }
}

