/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.ui.DebuggerColors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPointHighlighter {
    private final Project myProject;
    private RangeHighlighter myRangeHighlighter;
    private Editor myEditor;
    private XSourcePosition mySourcePosition;
    private OpenFileDescriptor myOpenFileDescriptor;
    private boolean myUseSelection;

    public ExecutionPointHighlighter(Project project) {
        this.myProject = project;
    }

    public void show(final @NotNull XSourcePosition position, final boolean useSelection) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter.show must not be null");
        }
        DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

            @Override
            public void run() {
                ExecutionPointHighlighter.this.doShow(position, useSelection);
            }
        });
    }

    public void hide() {
        DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

            @Override
            public void run() {
                ExecutionPointHighlighter.this.doHide();
            }
        });
    }

    public void navigateTo() {
        if (this.myOpenFileDescriptor != null) {
            FileEditorManager.getInstance((Project)this.myProject).openTextEditor(this.myOpenFileDescriptor, false);
        }
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        return this.myOpenFileDescriptor != null ? this.myOpenFileDescriptor.getFile() : null;
    }

    public void update() {
        this.show(this.mySourcePosition, this.myUseSelection);
    }

    private void doShow(@NotNull XSourcePosition position, boolean useSelection) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter.doShow must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.removeHighlighter();
        this.mySourcePosition = position;
        this.myEditor = this.openEditor();
        this.myUseSelection = useSelection;
        if (this.myEditor != null) {
            this.addHighlighter();
        }
    }

    @Nullable
    private Editor openEditor() {
        VirtualFile file = this.mySourcePosition.getFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        int offset = this.mySourcePosition.getOffset();
        this.myOpenFileDescriptor = offset < 0 || offset >= document.getTextLength() ? new OpenFileDescriptor(this.myProject, file, this.mySourcePosition.getLine(), 0) : new OpenFileDescriptor(this.myProject, file, offset);
        return FileEditorManager.getInstance((Project)this.myProject).openTextEditor(this.myOpenFileDescriptor, false);
    }

    private void doHide() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.removeHighlighter();
        this.myOpenFileDescriptor = null;
        this.myEditor = null;
    }

    private void removeHighlighter() {
        if (this.myUseSelection && this.myEditor != null) {
            this.myEditor.getSelectionModel().removeSelection();
        }
        if (this.myRangeHighlighter == null || this.myEditor == null) {
            return;
        }
        this.myEditor.getMarkupModel().removeHighlighter(this.myRangeHighlighter);
        this.myRangeHighlighter = null;
    }

    private void addHighlighter() {
        Document document;
        int line = this.mySourcePosition.getLine();
        if (line >= (document = this.myEditor.getDocument()).getLineCount()) {
            return;
        }
        if (this.myUseSelection) {
            this.myEditor.getSelectionModel().setSelection(document.getLineStartOffset(line), document.getLineEndOffset(line) + document.getLineSeparatorLength(line));
            return;
        }
        if (this.myRangeHighlighter != null) {
            return;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myRangeHighlighter = this.myEditor.getMarkupModel().addLineHighlighter(line, 5999, scheme.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES));
    }
}

