/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.grouping;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroup;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class XBreakpointFileGroupingRule<B extends XLineBreakpoint<?>>
extends XBreakpointGroupingRule<B, XBreakpointFileGroup> {
    public XBreakpointFileGroupingRule() {
        super("by-file", XDebuggerBundle.message((String)"rule.name.group.by.file", (Object[])new Object[0]));
    }

    public XBreakpointFileGroup getGroup(@NotNull B breakpoint, @NotNull Collection<XBreakpointFileGroup> groups) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointFileGroupingRule.getGroup must not be null");
        }
        if (groups == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointFileGroupingRule.getGroup must not be null");
        }
        XSourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        VirtualFile file = position.getFile();
        for (XBreakpointFileGroup group : groups) {
            if (!group.getFile().equals(file)) continue;
            return group;
        }
        return new XBreakpointFileGroup(file);
    }
}

