/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingsManager;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerUtilImpl
extends XDebuggerUtil {
    private XLineBreakpointType<?>[] myLineBreakpointTypes;
    private Map<Class<? extends XBreakpointType>, XBreakpointType<?, ?>> myBreakpointTypeByClass;

    public XLineBreakpointType<?>[] getLineBreakpointTypes() {
        if (this.myLineBreakpointTypes == null) {
            XBreakpointType<?, ?>[] types = XBreakpointUtil.getBreakpointTypes();
            ArrayList<XLineBreakpointType> lineBreakpointTypes = new ArrayList<XLineBreakpointType>();
            for (XBreakpointType<?, ?> type : types) {
                if (!(type instanceof XLineBreakpointType)) continue;
                lineBreakpointTypes.add((XLineBreakpointType)type);
            }
            this.myLineBreakpointTypes = lineBreakpointTypes.toArray(new XLineBreakpointType[lineBreakpointTypes.size()]);
        }
        return this.myLineBreakpointTypes;
    }

    public void toggleLineBreakpoint(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.toggleLineBreakpoint must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.toggleLineBreakpoint must not be null");
        }
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file, line, project)) continue;
            this.toggleLineBreakpoint(project, type, file, line);
            return;
        }
    }

    public boolean canPutBreakpointAt(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.canPutBreakpointAt must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.canPutBreakpointAt must not be null");
        }
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file, line, project)) continue;
            return true;
        }
        return false;
    }

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(final @NotNull Project project, final @NotNull XLineBreakpointType<P> type, final @NotNull VirtualFile file, final int line) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.toggleLineBreakpoint must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.toggleLineBreakpoint must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.toggleLineBreakpoint must not be null");
        }
        new WriteAction(){

            protected void run(Result result) {
                XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file, line);
                if (breakpoint != null) {
                    breakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
                } else {
                    XBreakpointProperties properties = type.createBreakpointProperties(file, line);
                    breakpointManager.addLineBreakpoint(type, file.getUrl(), line, properties);
                }
            }
        }.execute();
    }

    public void removeBreakpoint(final Project project, final XBreakpoint<?> breakpoint) {
        new WriteAction(){

            protected void run(Result result) {
                XDebuggerManager.getInstance((Project)project).getBreakpointManager().removeBreakpoint(breakpoint);
            }
        }.execute();
    }

    public <B extends XBreakpoint<?>> XBreakpointType<B, ?> findBreakpointType(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.findBreakpointType must not be null");
        }
        if (this.myBreakpointTypeByClass == null) {
            this.myBreakpointTypeByClass = new HashMap();
            for (XBreakpointType<?, ?> breakpointType : XBreakpointUtil.getBreakpointTypes()) {
                this.myBreakpointTypeByClass.put(breakpointType.getClass(), breakpointType);
            }
        }
        XBreakpointType<?, ?> type = this.myBreakpointTypeByClass.get(typeClass);
        return type;
    }

    public <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> aClass) {
        return XDebuggerSettingsManager.getInstance().getSettings(aClass);
    }

    public XValueContainer getValueContainer(DataContext dataContext) {
        return XDebuggerTreeActionBase.getSelectedValue(dataContext);
    }

    @Nullable
    public XSourcePosition createPosition(@NotNull VirtualFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.createPosition must not be null");
        }
        return XSourcePositionImpl.create(file, line);
    }

    @Nullable
    public XSourcePosition createPositionByOffset(@NotNull VirtualFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.createPositionByOffset must not be null");
        }
        return XSourcePositionImpl.createByOffset(file, offset);
    }

    public <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule() {
        return new XBreakpointFileGroupingRule();
    }

    @Nullable
    public static XSourcePosition getCaretPosition(@NotNull Project project, DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.getCaretPosition must not be null");
        }
        Editor editor = XDebuggerUtilImpl.getEditor(project, context);
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        int line = document.getLineNumber(offset);
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return XSourcePositionImpl.create(file, line);
    }

    @Nullable
    private static Editor getEditor(@NotNull Project project, DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.getEditor must not be null");
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        return editor;
    }

    public <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(final XBreakpointType<B, ?> type) {
        return new Comparator<B>(){

            @Override
            public int compare(B o1, B o2) {
                return type.getDisplayText(o1).compareTo(type.getDisplayText(o2));
            }
        };
    }

    public <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator() {
        return new Comparator<XLineBreakpoint<P>>(){

            @Override
            public int compare(XLineBreakpoint<P> o1, XLineBreakpoint<P> o2) {
                int fileCompare = o1.getFileUrl().compareTo(o2.getFileUrl());
                if (fileCompare != 0) {
                    return fileCompare;
                }
                return o1.getLine() - o2.getLine();
            }
        };
    }

    public static Class getStateClass(Class<? extends PersistentStateComponent> aClass) {
        return ReflectionUtil.getRawType((Type)ReflectionUtil.resolveVariableInHierarchy(PersistentStateComponent.class.getTypeParameters()[0], aClass));
    }

    @Nullable
    public static XDebuggerEvaluator getEvaluator(XSuspendContext suspendContext) {
        XStackFrame stackFrame;
        XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
        if (executionStack != null && (stackFrame = executionStack.getTopFrame()) != null) {
            return stackFrame.getEvaluator();
        }
        return null;
    }

    public void iterateLine(@NotNull Project project, @NotNull Document document, int line, @NotNull Processor<PsiElement> processor) {
        int lineEnd;
        int lineStart;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.iterateLine must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.iterateLine must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerUtilImpl.iterateLine must not be null");
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        try {
            lineStart = document.getLineStartOffset(line);
            lineEnd = document.getLineEndOffset(line);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        int off = lineStart;
        while (off < lineEnd) {
            PsiElement element = file.findElementAt(off);
            if (element != null) {
                if (!processor.process((Object)element)) {
                    return;
                }
                off = element.getTextRange().getEndOffset();
                continue;
            }
            ++off;
        }
    }
}

