/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import org.jetbrains.annotations.NotNull;

public class PhysicalDomParentStrategy
implements DomParentStrategy {
    private XmlElement myElement;
    private DomManagerImpl myDomManager;

    public PhysicalDomParentStrategy(@NotNull XmlElement element, DomManagerImpl domManager) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/PhysicalDomParentStrategy.<init> must not be null");
        }
        this.myElement = element;
        this.myDomManager = domManager;
    }

    @Override
    public DomInvocationHandler getParentHandler() {
        XmlTag parentTag = PhysicalDomParentStrategy.getParentTag(this.myElement);
        assert (parentTag != null);
        return this.myDomManager.getDomHandler(parentTag);
    }

    public static XmlTag getParentTag(XmlElement xmlElement) {
        return (XmlTag)PhysicalDomParentStrategy.getParentTagCandidate(xmlElement);
    }

    public static PsiElement getParentTagCandidate(XmlElement xmlElement) {
        PsiElement parent = xmlElement.getParent();
        return parent instanceof XmlEntityRef ? parent.getParent() : parent;
    }

    @Override
    @NotNull
    public final XmlElement getXmlElement() {
        XmlElement xmlElement = this.myElement;
        if (xmlElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/PhysicalDomParentStrategy.getXmlElement must not return null");
        }
        return xmlElement;
    }

    @Override
    @NotNull
    public DomParentStrategy refreshStrategy(DomInvocationHandler handler) {
        PhysicalDomParentStrategy physicalDomParentStrategy = this;
        if (physicalDomParentStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/PhysicalDomParentStrategy.refreshStrategy must not return null");
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/PhysicalDomParentStrategy.setXmlElement must not be null");
        }
        this.myElement = element;
        PhysicalDomParentStrategy physicalDomParentStrategy = this;
        if (physicalDomParentStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/PhysicalDomParentStrategy.setXmlElement must not return null");
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy clearXmlElement() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        VirtualDomParentStrategy virtualDomParentStrategy = new VirtualDomParentStrategy(parent);
        if (virtualDomParentStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/PhysicalDomParentStrategy.clearXmlElement must not return null");
        }
        return virtualDomParentStrategy;
    }

    @Override
    public boolean isValid() {
        return this.myElement.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhysicalDomParentStrategy)) {
            return false;
        }
        PhysicalDomParentStrategy that = (PhysicalDomParentStrategy)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }
}

