/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.paths.PathReference;
import com.intellij.util.containers.ConcurrentInstanceMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.PathReferenceConverter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConverterManagerImpl
implements ConverterManager {
    private final ConcurrentInstanceMap<Object> myConverterInstances = new ConcurrentInstanceMap();
    private final Map<Class, Converter> mySimpleConverters = new HashMap<Class, Converter>();

    ConverterManagerImpl() {
        this.mySimpleConverters.put(Integer.TYPE, Converter.INTEGER_CONVERTER);
        this.mySimpleConverters.put(Integer.class, Converter.INTEGER_CONVERTER);
        this.mySimpleConverters.put(Boolean.TYPE, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(Boolean.class, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(String.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(Object.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(PathReference.class, PathReferenceConverter.INSTANCE);
    }

    public void addConverter(Class clazz, Converter converter) {
        this.mySimpleConverters.put(clazz, converter);
    }

    @NotNull
    public final Converter getConverterInstance(Class<? extends Converter> converterClass) {
        Converter converter = this.getInstance(converterClass);
        if (converter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/ConverterManagerImpl.getConverterInstance must not return null");
        }
        return converter;
    }

    <T> T getInstance(Class<T> clazz) {
        return (T)this.myConverterInstances.get(clazz);
    }

    @Nullable
    public final Converter getConverterByClass(Class<?> convertingClass) {
        Converter converter = this.mySimpleConverters.get(convertingClass);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(convertingClass)) {
            return EnumConverter.createEnumConverter(convertingClass);
        }
        if (DomElement.class.isAssignableFrom(convertingClass)) {
            return DomResolveConverter.createConverter(convertingClass);
        }
        return null;
    }

    public <T extends Converter> void registerConverterImplementation(Class<T> converterInterface, T converterImpl) {
        this.myConverterInstances.put(converterInterface, converterImpl);
    }
}

