/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomApplicationComponent;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DomFileIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> NAME = ID.create((String)"DomFileIndex");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        @Override
        public boolean acceptInput(VirtualFile file) {
            return file.getFileType() == StdFileTypes.XML;
        }
    };
    private final DataIndexer<String, Void, FileContent> myDataIndexer = new DataIndexer<String, Void, FileContent>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Map<String, Void> map(FileContent inputData) {
            THashMap tHashMap;
            THashSet namespaces = new THashSet();
            XmlFileHeader header = NanoXmlUtil.parseHeader((InputStream)new ByteArrayInputStream(inputData.getContent()));
            ContainerUtil.addIfNotNull((Object)header.getPublicId(), (Collection)namespaces);
            ContainerUtil.addIfNotNull((Object)header.getSystemId(), (Collection)namespaces);
            ContainerUtil.addIfNotNull((Object)header.getRootTagNamespace(), (Collection)namespaces);
            String tagName = header.getRootTagLocalName();
            if (StringUtil.isNotEmpty((String)tagName)) {
                String[] strings;
                THashMap result = new THashMap();
                DomApplicationComponent component = DomApplicationComponent.getInstance();
                for (DomFileDescription description : component.getFileDescriptions(tagName)) {
                    strings = description.getAllPossibleRootTagNamespaces();
                    if (strings.length != 0 && !ContainerUtil.intersects(Arrays.asList(strings), (Collection)namespaces)) continue;
                    result.put((Object)description.getRootElementClass().getName(), null);
                }
                for (DomFileDescription description : component.getAcceptingOtherRootTagNameDescriptions()) {
                    strings = description.getAllPossibleRootTagNamespaces();
                    if (strings.length != 0 && !ContainerUtil.intersects(Arrays.asList(strings), (Collection)namespaces)) continue;
                    result.put((Object)description.getRootElementClass().getName(), null);
                }
                tHashMap = result;
                if (tHashMap == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileIndex$2.map must not return null");
                return tHashMap;
            }
            tHashMap = Collections.emptyMap();
            if (tHashMap != null) return tHashMap;
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomFileIndex$2.map must not return null");
        }
    };

    @Override
    public ID<String, Void> getName() {
        return NAME;
    }

    @Override
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myDataIndexer;
    }

    @Override
    public KeyDescriptor<String> getKeyDescriptor() {
        return new EnumeratorStringDescriptor();
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return INPUT_FILTER;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private static class RootTagReachedException
    extends RuntimeException {
        private RootTagReachedException() {
        }
    }
}

