/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ByteBufferMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FileKeyProvider
implements ByteBufferMap.KeyProvider<VirtualFile> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.FileKeyProvider");
    private final VirtualFile[] myFileIndex;
    private final TObjectIntHashMap<VirtualFile> myFileToIndexMap;

    public FileKeyProvider(VirtualFile[] fileIndex, TObjectIntHashMap<VirtualFile> fileToIndexMap) {
        this.myFileIndex = fileIndex;
        this.myFileToIndexMap = fileToIndexMap;
    }

    @Override
    public int hashCode(VirtualFile key) {
        int index = this.myFileToIndexMap.get((Object)key) - 1;
        return index;
    }

    @Override
    public void write(DataOutput out, VirtualFile key) throws IOException {
        int index = this.myFileToIndexMap.get((Object)key) - 1;
        LOG.assertTrue(index >= 0);
        out.writeInt(index);
    }

    @Override
    public int length(VirtualFile key) {
        return 4;
    }

    @Override
    public VirtualFile get(DataInput in) throws IOException {
        int index = in.readInt();
        return this.myFileIndex[index];
    }

    @Override
    public boolean equals(DataInput in, VirtualFile key) throws IOException {
        int index = in.readInt();
        return key.equals(this.myFileIndex[index]);
    }
}

