/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListToolTipHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadOperation;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThreadDumpPanel
extends JPanel {
    private static final Icon DAEMON = IconLoader.getIcon((String)"/debugger/threadStates/daemon_sign.png");
    private static final Icon PAUSE_ICON = IconLoader.getIcon((String)"/debugger/threadStates/paused.png");
    private static final Icon PAUSE_ICON_DAEMON = new LayeredIcon(new Icon[]{PAUSE_ICON, DAEMON});
    private static final Icon LOCKED_ICON = IconLoader.getIcon((String)"/debugger/threadStates/locked.png");
    private static final Icon LOCKED_ICON_DAEMON = new LayeredIcon(new Icon[]{LOCKED_ICON, DAEMON});
    private static final Icon RUNNING_ICON = IconLoader.getIcon((String)"/debugger/threadStates/running.png");
    private static final Icon RUNNING_ICON_DAEMON = new LayeredIcon(new Icon[]{RUNNING_ICON, DAEMON});
    private static final Icon SOCKET_ICON = IconLoader.getIcon((String)"/debugger/threadStates/socket.png");
    private static final Icon SOCKET_ICON_DAEMON = new LayeredIcon(new Icon[]{SOCKET_ICON, DAEMON});
    private static final Icon IDLE_ICON = IconLoader.getIcon((String)"/debugger/threadStates/idle.png");
    private static final Icon IDLE_ICON_DAEMON = new LayeredIcon(new Icon[]{IDLE_ICON, DAEMON});
    private static final Icon EDT_BUSY_ICON = IconLoader.getIcon((String)"/debugger/threadStates/edtBusy.png");
    private static final Icon EDT_BUSY_ICON_DAEMON = new LayeredIcon(new Icon[]{EDT_BUSY_ICON, DAEMON});
    private static final Icon IO_ICON = IconLoader.getIcon((String)"/debugger/threadStates/io.png");
    private static final Icon IO_ICON_DAEMON = new LayeredIcon(new Icon[]{IO_ICON, DAEMON});
    private JList myThreadList;

    public ThreadDumpPanel(Project project, final ConsoleView consoleView, DefaultActionGroup toolbarActions, List<ThreadState> threadDump) {
        super(new BorderLayout());
        ThreadState[] data = threadDump.toArray(new ThreadState[threadDump.size()]);
        DefaultListModel<ThreadState> model = new DefaultListModel<ThreadState>();
        for (ThreadState threadState : data) {
            model.addElement(threadState);
        }
        this.myThreadList = new JList(model);
        this.myThreadList.setCellRenderer(new ThreadListCellRenderer());
        this.myThreadList.setSelectionMode(0);
        this.myThreadList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ThreadDumpPanel.this.myThreadList.getSelectedIndex();
                if (index >= 0) {
                    ThreadState selection = (ThreadState)ThreadDumpPanel.this.myThreadList.getModel().getElementAt(index);
                    AnalyzeStacktraceUtil.printStacktrace(consoleView, selection.getStackTrace());
                } else {
                    AnalyzeStacktraceUtil.printStacktrace(consoleView, "");
                }
                ThreadDumpPanel.this.myThreadList.repaint();
            }
        });
        ListToolTipHandler.install(this.myThreadList);
        toolbarActions.add((AnAction)new CopyToClipboardAction(threadDump, project));
        toolbarActions.add((AnAction)new SortThreadsAction());
        this.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false).getComponent(), "West");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)new JScrollPane(this.myThreadList));
        splitter.setSecondComponent(consoleView.getComponent());
        this.add((Component)splitter, "Center");
    }

    private static Icon getThreadStateIcon(ThreadState threadState) {
        boolean daemon = threadState.isDaemon();
        if (threadState.isSleeping()) {
            return daemon ? PAUSE_ICON_DAEMON : PAUSE_ICON;
        }
        if (threadState.isWaiting()) {
            return daemon ? LOCKED_ICON_DAEMON : LOCKED_ICON;
        }
        if (threadState.getOperation() == ThreadOperation.Socket) {
            return daemon ? SOCKET_ICON_DAEMON : SOCKET_ICON;
        }
        if (threadState.getOperation() == ThreadOperation.IO) {
            return daemon ? IO_ICON_DAEMON : IO_ICON;
        }
        if (threadState.isEDT()) {
            if ("idle".equals(threadState.getThreadStateDetail())) {
                return daemon ? IDLE_ICON_DAEMON : IDLE_ICON;
            }
            return daemon ? EDT_BUSY_ICON_DAEMON : EDT_BUSY_ICON;
        }
        return daemon ? RUNNING_ICON_DAEMON : RUNNING_ICON;
    }

    private static StateCode getThreadStateCode(ThreadState state) {
        if (state.isSleeping()) {
            return StateCode.PAUSED;
        }
        if (state.isWaiting()) {
            return StateCode.LOCKED;
        }
        if (state.getOperation() == ThreadOperation.Socket) {
            return StateCode.RUN_SOCKET;
        }
        if (state.getOperation() == ThreadOperation.IO) {
            return StateCode.RUN_IO;
        }
        if (state.isEDT()) {
            return "idle".equals(state.getThreadStateDetail()) ? StateCode.IDLE : StateCode.EDT;
        }
        return StateCode.RUN;
    }

    private static SimpleTextAttributes getAttributes(ThreadState threadState) {
        if (threadState.isSleeping()) {
            return SimpleTextAttributes.GRAY_ATTRIBUTES;
        }
        if (threadState.isEmptyStackTrace() || ThreadDumpParser.isKnownJdkThread(threadState)) {
            return new SimpleTextAttributes(0, Color.GRAY.brighter());
        }
        if (threadState.isEDT()) {
            return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public void selectStackFrame(int index) {
        this.myThreadList.setSelectedIndex(index);
    }

    private static class CopyToClipboardAction
    extends AnAction {
        private final List<ThreadState> myThreadDump;
        private final Project myProject;

        public CopyToClipboardAction(List<ThreadState> threadDump, Project project) {
            super("Copy to Clipboard", "Copy whole thread dump to clipboard", IconLoader.getIcon((String)"/general/copy.png"));
            this.myThreadDump = threadDump;
            this.myProject = project;
        }

        public void actionPerformed(AnActionEvent e) {
            StringBuilder buf = new StringBuilder();
            for (ThreadState state : this.myThreadDump) {
                buf.append(state.getStackTrace()).append("\n\n");
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(buf.toString()));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!CopyToClipboardAction.this.myProject.isDisposed()) {
                        ToolWindowManager.getInstance((Project)CopyToClipboardAction.this.myProject).notifyByBalloon(ToolWindowId.RUN, MessageType.INFO, "Full thread dump was successfully copied to clipboard");
                    }
                }
            });
        }
    }

    private class SortThreadsAction
    extends AnAction {
        private Comparator<ThreadState> BY_TYPE;
        private Comparator<ThreadState> BY_NAME;
        private Comparator<ThreadState> COMPARATOR;
        private Icon typeIcon;
        private Icon nameIcon;
        private static final String TYPE_LABEL = "Sort threads by type";
        private static final String NAME_LABEL = "Sort threads by name";

        public SortThreadsAction() {
            super(TYPE_LABEL);
            this.BY_TYPE = new Comparator<ThreadState>(){

                @Override
                public int compare(ThreadState o1, ThreadState o2) {
                    int s2;
                    int s1 = ThreadDumpPanel.getThreadStateCode(o1).ordinal();
                    if (s1 == (s2 = ThreadDumpPanel.getThreadStateCode(o2).ordinal())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return s1 < s2 ? -1 : 1;
                }
            };
            this.BY_NAME = new Comparator<ThreadState>(){

                @Override
                public int compare(ThreadState o1, ThreadState o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            this.COMPARATOR = this.BY_TYPE;
            this.typeIcon = IconLoader.getIcon((String)"/objectBrowser/sortByType.png");
            this.nameIcon = IconLoader.getIcon((String)"/icons/inspector/sortByName.png");
        }

        public void actionPerformed(AnActionEvent e) {
            DefaultListModel model = (DefaultListModel)ThreadDumpPanel.this.myThreadList.getModel();
            ThreadState selected = (ThreadState)ThreadDumpPanel.this.myThreadList.getSelectedValue();
            ArrayList<ThreadState> states = new ArrayList<ThreadState>();
            for (int i = 0; i < model.getSize(); ++i) {
                states.add((ThreadState)model.getElementAt(i));
            }
            Collections.sort(states, this.COMPARATOR);
            int selectedIndex = 0;
            for (int i = 0; i < states.size(); ++i) {
                ThreadState state = (ThreadState)states.get(i);
                model.setElementAt(state, i);
                if (state != selected) continue;
                selectedIndex = i;
            }
            ThreadDumpPanel.this.myThreadList.setSelectedIndex(selectedIndex);
            this.COMPARATOR = this.COMPARATOR == this.BY_TYPE ? this.BY_NAME : this.BY_TYPE;
            this.update(e);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(this.COMPARATOR == this.BY_TYPE ? this.typeIcon : this.nameIcon);
            e.getPresentation().setText(this.COMPARATOR == this.BY_TYPE ? TYPE_LABEL : NAME_LABEL);
        }
    }

    private static class ThreadListCellRenderer
    extends ColoredListCellRenderer {
        private ThreadListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            ThreadState threadState = (ThreadState)value;
            this.setIcon(ThreadDumpPanel.getThreadStateIcon(threadState));
            if (!selected) {
                ThreadState selectedThread = (ThreadState)list.getSelectedValue();
                if (threadState.isDeadlocked()) {
                    this.setBackground(LightColors.RED);
                } else if (selectedThread != null && threadState.isAwaitedBy(selectedThread)) {
                    this.setBackground(Color.YELLOW);
                } else {
                    this.setBackground(UIUtil.getListBackground());
                }
            }
            SimpleTextAttributes attrs = ThreadDumpPanel.getAttributes(threadState);
            this.append(threadState.getName() + " (", attrs);
            String detail = threadState.getThreadStateDetail();
            if (detail == null) {
                detail = threadState.getState();
            }
            if (detail.length() > 30) {
                detail = detail.substring(0, 30) + "...";
            }
            this.append(detail, attrs);
            this.append(")", attrs);
            if (threadState.getExtraState() != null) {
                this.append(" [" + threadState.getExtraState() + "]", attrs);
            }
        }
    }

    private static enum StateCode {
        RUN,
        RUN_IO,
        RUN_SOCKET,
        PAUSED,
        LOCKED,
        EDT,
        IDLE;

    }
}

