/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzeStacktraceUtil {
    private AnalyzeStacktraceUtil() {
    }

    public static void printStacktrace(final ConsoleView consoleView, String unscrambledTrace) {
        consoleView.clear();
        consoleView.print(unscrambledTrace + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        consoleView.performWhenNoDeferredOutput(new Runnable(){

            @Override
            public void run() {
                consoleView.scrollTo(0);
            }
        });
    }

    @Nullable
    public static String getTextInClipboard() {
        String text = null;
        try {
            Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(AnalyzeStacktraceUtil.class);
            if (contents != null) {
                text = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public static ConsoleView addConsole(Project project, @Nullable ConsoleFactory consoleFactory, String tabTitle) {
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JComponent consoleComponent = consoleFactory != null ? consoleFactory.createConsoleComponent(consoleView, toolbarActions) : new MyConsolePanel((ExecutionConsole)consoleView, (ActionGroup)toolbarActions);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleComponent, tabTitle){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor, project));
        for (AnAction action : consoleView.createConsoleActions()) {
            toolbarActions.add(action);
        }
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(executor, descriptor);
        return consoleView;
    }

    public static StacktraceEditorPanel createEditorPanel(Project project, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/unscramble/AnalyzeStacktraceUtil.createEditorPanel must not be null");
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Editor editor = editorFactory.createEditor(document);
        EditorSettings settings = editor.getSettings();
        settings.setFoldingOutlineShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setRightMarginShown(false);
        StacktraceEditorPanel editorPanel = new StacktraceEditorPanel(project, editor);
        editorPanel.setPreferredSize(new Dimension(600, 400));
        Disposer.register((Disposable)parentDisposable, (Disposable)editorPanel);
        return editorPanel;
    }

    public static final class StacktraceEditorPanel
    extends JPanel
    implements DataProvider,
    Disposable {
        private Project myProject;
        private final Editor myEditor;

        public StacktraceEditorPanel(Project project, Editor editor) {
            super(new BorderLayout());
            this.myProject = project;
            this.myEditor = editor;
            this.add(this.myEditor.getComponent());
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.EDITOR.is(dataId)) {
                return this.myEditor;
            }
            return null;
        }

        public Editor getEditor() {
            return this.myEditor;
        }

        public final void setText(final @NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/unscramble/AnalyzeStacktraceUtil$StacktraceEditorPanel.setText must not be null");
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            Document document = StacktraceEditorPanel.this.myEditor.getDocument();
                            document.replaceString(0, document.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text));
                        }
                    });
                }
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable, "", (Object)this);
        }

        public void pasteTextFromClipboard() {
            String text = AnalyzeStacktraceUtil.getTextInClipboard();
            if (text != null) {
                this.setText(text);
            }
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }

        public String getText() {
            return this.myEditor.getDocument().getText();
        }

        public JComponent getEditorComponent() {
            return this.myEditor.getContentComponent();
        }
    }

    private static final class MyConsolePanel
    extends JPanel {
        public MyConsolePanel(ExecutionConsole consoleView, ActionGroup toolbarActions) {
            super(new BorderLayout());
            JPanel toolbarPanel = new JPanel(new BorderLayout());
            toolbarPanel.add(ActionManager.getInstance().createActionToolbar("unknown", toolbarActions, false).getComponent());
            this.add((Component)toolbarPanel, "West");
            this.add((Component)consoleView.getComponent(), "Center");
        }
    }

    public static interface ConsoleFactory {
        public JComponent createConsoleComponent(ConsoleView var1, DefaultActionGroup var2);
    }
}

