/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.LicenseeInfoProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class Splash
extends JDialog {
    private final Icon myImage;
    private final JLabel myLabel;

    public Splash(String imageName, Color textColor) {
        this.setUndecorated(true);
        this.setResizable(false);
        this.setModal(false);
        this.setFocusableWindowState(false);
        Icon originalImage = IconLoader.getIcon((String)imageName);
        this.myImage = new MyIcon(originalImage, textColor);
        this.myLabel = new JLabel(this.myImage);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.myLabel, "Center");
        Dimension size = this.getPreferredSize();
        this.setSize(size);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void show() {
        super.show();
        this.toFront();
        this.myLabel.paintImmediately(0, 0, this.myImage.getIconWidth(), this.myImage.getIconHeight());
    }

    public static boolean showLicenseeInfo(Graphics g, int x, int y, int height, Color textColor) {
        if (ApplicationInfoImpl.getShadowInstance().showLicenseeInfo()) {
            g.setFont(new Font("Arial", 1, 11));
            g.setColor(textColor);
            LicenseeInfoProvider provider = LicenseeInfoProvider.getInstance();
            if (provider != null) {
                g.drawString(provider.getLicensedToMessage(), x + 20, y + height - 52);
                g.drawString(provider.getLicenseRestrictionsMessage(), x + 20, y + height - 32);
            }
            return true;
        }
        return false;
    }

    private static final class MyIcon
    implements Icon {
        private final Icon myOriginalIcon;
        private final Color myTextColor;

        public MyIcon(Icon originalIcon, Color textColor) {
            this.myOriginalIcon = originalIcon;
            this.myTextColor = textColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            MyIcon.yeild();
            this.myOriginalIcon.paintIcon(c, g, x, y);
            Splash.showLicenseeInfo(g, x, y, this.getIconHeight(), this.myTextColor);
        }

        private static void yeild() {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public int getIconWidth() {
            return this.myOriginalIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myOriginalIcon.getIconHeight();
        }
    }
}

