/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.Nullable;

public class BalloonImpl
implements Disposable,
Balloon,
LightweightWindow {
    private MyComponent myComp;
    private JLayeredPane myLayeredPane;
    private Position myPosition;
    private Point myTargetPoint;
    private boolean myHideOnFrameResize;
    private final Color myBorderColor;
    private final Color myFillColor;
    private final Insets myContainerInsets = new Insets(4, 4, 4, 4);
    private boolean myLastMoveWasInsideBalloon;
    private Rectangle myForcedBounds;
    private final AWTEventListener myAwtActivityListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            MouseEvent me;
            if (BalloonImpl.this.myHideOnMouse && (event.getID() == 501 || event.getID() == 502 || event.getID() == 500)) {
                MouseEvent me2 = (MouseEvent)event;
                if (BalloonImpl.this.isInsideBalloon(me2)) {
                    return;
                }
                BalloonImpl.this.hide();
                return;
            }
            if (BalloonImpl.this.myClickHandler != null && event.getID() == 500 && !((me = (MouseEvent)event).getComponent() instanceof CloseButton) && BalloonImpl.this.isInsideBalloon(me)) {
                BalloonImpl.this.myClickHandler.actionPerformed(new ActionEvent(BalloonImpl.this, 1001, "click", me.getModifiersEx()));
                if (BalloonImpl.this.myCloseOnClick) {
                    BalloonImpl.this.hide();
                    return;
                }
            }
            if (BalloonImpl.this.myEnableCloseButton && event.getID() == 503) {
                me = (MouseEvent)event;
                boolean inside = BalloonImpl.this.isInsideBalloon(me);
                boolean moveChanged = inside != BalloonImpl.this.myLastMoveWasInsideBalloon;
                BalloonImpl.this.myLastMoveWasInsideBalloon = inside;
                if (moveChanged) {
                    BalloonImpl.this.myComp.repaint();
                }
            }
            if (BalloonImpl.this.myHideOnKey && event.getID() == 401) {
                KeyEvent ke = (KeyEvent)event;
                if (SwingUtilities.isDescendingFrom(ke.getComponent(), BalloonImpl.this.myComp) || ke.getComponent() == BalloonImpl.this.myComp) {
                    return;
                }
                BalloonImpl.this.hide();
            }
        }
    };
    private long myFadeoutTime;
    private Dimension myDefaultPrefSize;
    private ActionListener myClickHandler;
    private boolean myCloseOnClick;
    private CopyOnWriteArraySet<JBPopupListener> myListeners = new CopyOnWriteArraySet();
    private boolean myVisible;
    private final ComponentAdapter myComponentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (BalloonImpl.this.myHideOnFrameResize) {
                BalloonImpl.this.hide();
            }
        }
    };
    private Animator myAnimator;
    private boolean myShowPointer;
    private boolean myDisposed;
    private final JComponent myContent;
    private final boolean myHideOnMouse;
    private final boolean myHideOnKey;
    private boolean myEnableCloseButton;
    private Icon myCloseButton = IconLoader.getIcon((String)"/general/balloonClose.png");
    public static final Position BELOW = new Below();
    public static final Position ABOVE = new Above();
    public static final Position AT_RIGHT = new AtRight();
    public static final Position AT_LEFT = new AtLeft();

    private boolean isInsideBalloon(MouseEvent me) {
        if (!me.getComponent().isShowing()) {
            return true;
        }
        if (SwingUtilities.isDescendingFrom(me.getComponent(), this.myComp) || me.getComponent() == this.myComp) {
            return true;
        }
        Point mouseEventPoint = me.getPoint();
        SwingUtilities.convertPointToScreen(mouseEventPoint, me.getComponent());
        if (!this.myComp.isShowing()) {
            return false;
        }
        Rectangle compRect = new Rectangle(this.myComp.getLocationOnScreen(), this.myComp.getSize());
        return compRect.contains(mouseEventPoint);
    }

    public BalloonImpl(JComponent content, Color borderColor, Color fillColor, boolean hideOnMouse, boolean hideOnKey, boolean showPointer, boolean enableCloseButton, long fadeoutTime, boolean hideOnFrameResize, ActionListener clickHandler, boolean closeOnClick) {
        this.myBorderColor = borderColor;
        this.myFillColor = fillColor;
        this.myContent = content;
        this.myHideOnMouse = hideOnMouse;
        this.myHideOnKey = hideOnKey;
        this.myShowPointer = showPointer;
        this.myEnableCloseButton = enableCloseButton;
        this.myHideOnFrameResize = hideOnFrameResize;
        this.myClickHandler = clickHandler;
        this.myCloseOnClick = closeOnClick;
        this.myFadeoutTime = fadeoutTime;
    }

    public void show(RelativePoint target, Balloon.Position position) {
        Position pos = BELOW;
        switch (position) {
            case atLeft: {
                pos = AT_LEFT;
                break;
            }
            case atRight: {
                pos = AT_RIGHT;
                break;
            }
            case below: {
                pos = BELOW;
                break;
            }
            case above: {
                pos = ABOVE;
            }
        }
        this.show(target, pos);
    }

    private void show(RelativePoint target, Position position) {
        if (this.isVisible()) {
            return;
        }
        assert (!this.myDisposed) : "Balloon is already disposed";
        assert (target.getComponent().isShowing()) : "Target component is not showing: " + target;
        Window window = SwingUtilities.getWindowAncestor(target.getComponent());
        JRootPane root = null;
        if (window instanceof JFrame) {
            root = ((JFrame)window).getRootPane();
        } else if (window instanceof JDialog) {
            root = ((JDialog)window).getRootPane();
        } else assert (false) : window;
        this.myVisible = true;
        this.myLayeredPane = root.getLayeredPane();
        this.myPosition = position;
        this.myLayeredPane.addComponentListener(this.myComponentListener);
        EmptyBorder border = this.myShowPointer ? this.myPosition.createBorder(this) : new EmptyBorder(this.getNormalInset(), this.getNormalInset(), this.getNormalInset(), this.getNormalInset());
        this.myComp = new MyComponent(this.myContent, this, border);
        this.myTargetPoint = target.getPoint((Component)this.myLayeredPane);
        this.myComp.clear();
        this.myComp.myAlpha = 0.0f;
        for (JBPopupListener each : this.myListeners) {
            each.beforeShown(new LightweightWindowEvent((LightweightWindow)this));
        }
        this.myLayeredPane.add((Component)this.myComp, JLayeredPane.POPUP_LAYER);
        this.myPosition.updateLocation(this);
        this.runAnimation(true, this.myLayeredPane);
        this.myLayeredPane.revalidate();
        this.myLayeredPane.repaint();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAwtActivityListener, 56L);
    }

    public void show(JLayeredPane pane) {
        this.show(pane, null);
    }

    public void show(JLayeredPane pane, @Nullable Rectangle bounds) {
        if (bounds != null) {
            this.myForcedBounds = bounds;
        }
        this.show(new RelativePoint((Component)pane, new Point(0, 0)), Balloon.Position.above);
    }

    private void runAnimation(boolean forward, final JLayeredPane layeredPane) {
        if (this.myAnimator != null) {
            Disposer.dispose((Disposable)this.myAnimator);
        }
        this.myAnimator = new Animator("Balloon", 10, 500, false, 0, 1, forward){

            public void paintNow(float frame, float totalFrames, float cycle) {
                if (BalloonImpl.this.myComp.getParent() == null) {
                    return;
                }
                BalloonImpl.this.myComp.setAlpha(frame / totalFrames);
            }

            protected void paintCycleEnd() {
                if (BalloonImpl.this.myComp.getParent() == null) {
                    return;
                }
                if (this.isForward()) {
                    BalloonImpl.this.myComp.clear();
                    BalloonImpl.this.myComp.repaint();
                    BalloonImpl.this.startFadeoutTimer();
                } else {
                    layeredPane.remove(BalloonImpl.this.myComp);
                    layeredPane.revalidate();
                    layeredPane.repaint();
                }
                Disposer.dispose((Disposable)this);
            }

            public void dispose() {
                super.dispose();
                BalloonImpl.this.myAnimator = null;
            }
        };
        this.myAnimator.setTakInitialDelay(false);
        this.myAnimator.resume();
    }

    private void startFadeoutTimer() {
        if (this.myFadeoutTime > 0L) {
            Alarm fadeoutAlarm = new Alarm((Disposable)this);
            fadeoutAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    BalloonImpl.this.hide();
                }
            }, (int)this.myFadeoutTime, null);
        }
    }

    int getArc() {
        return 6;
    }

    int getPointerWidth() {
        return 12;
    }

    int getNormalInset() {
        return 4;
    }

    int getShadowShift() {
        return 10;
    }

    int getPointerLength() {
        return 16;
    }

    public void hide() {
        Disposer.dispose((Disposable)this);
        for (JBPopupListener each : this.myListeners) {
            each.onClosed(new LightweightWindowEvent((LightweightWindow)this));
        }
    }

    public void addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        Disposer.dispose((Disposable)this);
        this.myDisposed = true;
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtActivityListener);
        if (this.myLayeredPane != null) {
            this.myLayeredPane.removeComponentListener(this.myComponentListener);
            this.runAnimation(false, this.myLayeredPane);
        }
        this.myVisible = false;
        this.onDisposed();
    }

    protected void onDisposed() {
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setShowPointer(boolean show) {
        this.myShowPointer = show;
    }

    public Icon getCloseButton() {
        return this.myCloseButton;
    }

    public void setBounds(Rectangle bounds) {
        this.myForcedBounds = bounds;
        if (this.myPosition != null) {
            this.myPosition.updateLocation(this);
        }
    }

    public Dimension getPreferredSize() {
        if (this.myComp != null) {
            return this.myComp.getPreferredSize();
        }
        if (this.myDefaultPrefSize == null) {
            EmptyBorder border = new EmptyBorder(this.getNormalInset(), this.getNormalInset(), this.getNormalInset(), this.getNormalInset());
            MyComponent c = new MyComponent(this.myContent, this, border);
            this.myDefaultPrefSize = c.getPreferredSize();
        }
        return this.myDefaultPrefSize;
    }

    public static void main(String[] args) {
        IconLoader.activate();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel(new BorderLayout());
        frame.getContentPane().add((Component)content, "Center");
        JTree tree = new JTree();
        content.add(tree);
        final Ref balloon = new Ref();
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (balloon.get() != null && ((BalloonImpl)balloon.get()).isVisible()) {
                    ((BalloonImpl)balloon.get()).dispose();
                } else {
                    JEditorPane pane = new JEditorPane();
                    pane.setBorder(new EmptyBorder(6, 6, 6, 6));
                    pane.setEditorKit(new HTMLEditorKit());
                    pane.setText(UIUtil.toHtml((String)"<html><body><center>Really cool balloon<br>Really fucking <a href=\\\"http://jetbrains.com\\\">big</a></center></body></html"));
                    Dimension size = new JLabel(pane.getText()).getPreferredSize();
                    pane.setEditable(false);
                    pane.setOpaque(false);
                    pane.setBorder(null);
                    pane.setPreferredSize(size);
                    balloon.set((Object)new BalloonImpl(pane, Color.black, MessageType.ERROR.getPopupBackground(), true, true, true, true, 2000L, true, null, false));
                    ((BalloonImpl)balloon.get()).setShowPointer(false);
                    if (e.isControlDown()) {
                        ((BalloonImpl)balloon.get()).show(new RelativePoint(e), ABOVE);
                    } else if (e.isAltDown()) {
                        ((BalloonImpl)balloon.get()).show(new RelativePoint(e), BELOW);
                    } else if (e.isMetaDown()) {
                        ((BalloonImpl)balloon.get()).show(new RelativePoint(e), AT_LEFT);
                    } else {
                        ((BalloonImpl)balloon.get()).show(new RelativePoint(e), AT_RIGHT);
                    }
                }
            }
        });
        frame.setBounds(300, 300, 300, 300);
        frame.show();
    }

    private static class Shaper {
        private final GeneralPath myPath = new GeneralPath();
        Rectangle myBounds;
        private final int myTargetSide;
        private final BalloonImpl myBalloon;

        public Shaper(BalloonImpl balloon, Rectangle bounds, Point targetPoint, int targetSide) {
            this.myBalloon = balloon;
            this.myBounds = bounds;
            this.myTargetSide = targetSide;
            this.start(targetPoint);
        }

        private void start(Point start) {
            this.myPath.moveTo(start.x, start.y);
        }

        public Shaper roundUpRight() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y - this.myBalloon.getArc(), this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            return this;
        }

        public Shaper roundRightDown() {
            this.myPath.quadTo(this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            return this;
        }

        public Shaper roundLeftUp() {
            this.myPath.quadTo(this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            return this;
        }

        public Shaper roundLeftDown() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y + this.myBalloon.getArc(), this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            return this;
        }

        public Point getCurrent() {
            return new Point((int)this.myPath.getCurrentPoint().getX(), (int)this.myPath.getCurrentPoint().getY());
        }

        public Shaper line(int deltaX, int deltaY) {
            this.myPath.lineTo(this.getCurrent().x + deltaX, this.getCurrent().y + deltaY);
            return this;
        }

        public Shaper lineTo(int x, int y) {
            this.myPath.lineTo(x, y);
            return this;
        }

        private int getTargetDelta(int effectiveSide) {
            return effectiveSide == this.myTargetSide ? this.myBalloon.getPointerLength() : 0;
        }

        public Shaper toRightCurve() {
            this.myPath.lineTo((int)this.myBounds.getMaxX() - this.myBalloon.getArc() - this.getTargetDelta(4) - 1, this.getCurrent().y);
            return this;
        }

        public Shaper toBottomCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getMaxY() - this.myBalloon.getArc() - this.getTargetDelta(3) - 1);
            return this;
        }

        public Shaper toLeftCurve() {
            this.myPath.lineTo((int)this.myBounds.getX() + this.myBalloon.getArc() + this.getTargetDelta(2), this.getCurrent().y);
            return this;
        }

        public Shaper toTopCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getY() + this.myBalloon.getArc() + this.getTargetDelta(1));
            return this;
        }

        public void close() {
            this.myPath.closePath();
        }

        public Shape getShape() {
            return this.myPath;
        }
    }

    private class MyComponent
    extends JPanel {
        private BufferedImage myImage;
        private float myAlpha;
        private final BalloonImpl myBalloon;
        private CloseButton myCloseRec;
        private BaseButtonBehavior myButton;
        private final Wrapper myContent;

        private MyComponent(JComponent content, BalloonImpl balloon, EmptyBorder shapeBorder) {
            this.myCloseRec = new CloseButton();
            this.setOpaque(false);
            this.setLayout(null);
            this.myBalloon = balloon;
            this.myContent = new Wrapper(content);
            this.myContent.setBorder((Border)shapeBorder);
            this.myContent.setOpaque(false);
            this.setBorder(new EmptyBorder(balloon.getCloseButton().getIconHeight() / 3, 0, 0, balloon.getCloseButton().getIconWidth() / 3));
            this.add((Component)this.myContent);
            this.myButton = new BaseButtonBehavior((JComponent)((Object)this.myCloseRec), TimedDeadzone.NULL){

                protected void execute(MouseEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MyComponent.this.myBalloon.hide();
                        }
                    });
                }
            };
            this.add((Component)((Object)this.myCloseRec));
            this.setComponentZOrder((Component)this.myContent, 1);
            this.setComponentZOrder((Component)((Object)this.myCloseRec), 0);
        }

        public void clear() {
            this.myImage = null;
            this.myAlpha = -1.0f;
        }

        @Override
        public void doLayout() {
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            this.myContent.setBounds(insets.left, insets.right, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            if (this.myBalloon.myEnableCloseButton) {
                Icon icon = this.myBalloon.getCloseButton();
                Rectangle bounds = this.getBounds();
                this.myCloseRec.setBounds(bounds.width - icon.getIconWidth(), 0, icon.getIconWidth(), icon.getIconHeight());
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myContent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myContent.getMinimumSize());
        }

        private Dimension addInsets(Dimension size) {
            Insets insets = this.getInsets();
            if (insets != null) {
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
            }
            return size;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.myLayeredPane, this.myBalloon.myTargetPoint, this);
            if (this.myImage == null && this.myAlpha != -1.0f) {
                this.myImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                this.myBalloon.myPosition.paintComponent(this.myBalloon, this.myContent.getBounds(), (Graphics2D)this.myImage.getGraphics(), pointTarget);
            }
            if (this.myImage != null && this.myAlpha != -1.0f) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
                g2d.drawImage((Image)this.myImage, 0, 0, null);
            } else {
                this.myBalloon.myPosition.paintComponent(this.myBalloon, this.myContent.getBounds(), (Graphics2D)g, pointTarget);
            }
        }

        @Override
        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (this.myCloseRec.getWidth() > 0 && this.myBalloon.myLastMoveWasInsideBalloon) {
                boolean pressed = this.myButton.isPressedByMouse();
                this.myBalloon.getCloseButton().paintIcon(this, g, this.myCloseRec.getX() + (pressed ? 1 : 0), this.myCloseRec.getY() + (pressed ? 1 : 0));
            }
        }

        public void setAlpha(float alpha) {
            this.myAlpha = alpha;
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private class CloseButton
    extends NonOpaquePanel {
        private CloseButton() {
        }
    }

    private static class AtLeft
    extends Position {
        private AtLeft() {
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            return new EmptyBorder(balloon.getNormalInset(), balloon.getNormalInset(), balloon.getNormalInset(), balloon.getPointerLength());
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, new Dimension(0, 0)), (Dimension)balloonSize);
            return new Point(targetPoint.x - balloonSize.width, center.y);
        }

        protected void convertBoundsToContent(Rectangle bounds, BalloonImpl balloon) {
            bounds.width -= balloon.getPointerLength();
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 4);
            shaper.line(-balloon.getPointerLength(), balloon.getPointerWidth() / 2);
            shaper.toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().lineTo(shaper.getCurrent().x, pointTarget.y - balloon.getPointerWidth() / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        protected Shape getShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            bounds.width -= balloon.getPointerLength();
            return new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, balloon.getArc(), balloon.getArc());
        }
    }

    private static class AtRight
    extends Position {
        private AtRight() {
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            return new EmptyBorder(balloon.getNormalInset(), balloon.getPointerLength(), balloon.getNormalInset(), balloon.getNormalInset());
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, new Dimension(0, 0)), (Dimension)balloonSize);
            return new Point(targetPoint.x, center.y);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 2);
            shaper.line(balloon.getPointerLength(), -balloon.getPointerWidth() / 2).toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().lineTo(shaper.getCurrent().x, pointTarget.y + balloon.getPointerWidth() / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        protected void convertBoundsToContent(Rectangle bounds, BalloonImpl balloon) {
            bounds.x += balloon.getPointerLength();
            bounds.width -= balloon.getPointerLength();
        }

        protected Shape getShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            bounds.x += balloon.getPointerLength();
            bounds.width -= balloon.getPointerLength();
            return new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, balloon.getArc(), balloon.getArc());
        }
    }

    private static class Above
    extends Position {
        private Above() {
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            return new EmptyBorder(balloon.getNormalInset(), balloon.getNormalInset(), balloon.getPointerLength(), balloon.getNormalInset());
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, new Dimension(0, 0)), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y - balloonSize.height);
        }

        protected void convertBoundsToContent(Rectangle bounds, BalloonImpl balloon) {
            bounds.height -= balloon.getPointerLength() - 1;
        }

        protected Shape getShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            bounds.y -= balloon.getPointerLength();
            bounds.height -= balloon.getPointerLength();
            return new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, balloon.getArc(), balloon.getArc());
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 3);
            shaper.line(-balloon.getPointerWidth() / 2, -balloon.getPointerLength() + 1);
            shaper.toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().line(0, 2).roundLeftDown().lineTo(pointTarget.x + balloon.getPointerWidth() / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }
    }

    private static class Below
    extends Position {
        private Below() {
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            return new EmptyBorder(balloon.getPointerLength(), balloon.getNormalInset(), balloon.getNormalInset(), balloon.getNormalInset());
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize) {
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, new Dimension(0, 0)), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y);
        }

        protected void convertBoundsToContent(Rectangle bounds, BalloonImpl balloon) {
            bounds.y += balloon.getPointerLength();
            bounds.height -= balloon.getPointerLength() - 1;
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 1);
            shaper.line(balloon.getPointerWidth() / 2, balloon.getPointerLength()).toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().lineTo(pointTarget.x - balloon.getPointerWidth() / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y);
            shaper.close();
            return shaper.getShape();
        }

        protected Shape getShape(Rectangle bounds, Graphics2D g, Point pointTarget, BalloonImpl balloon) {
            bounds.y += balloon.getPointerLength();
            bounds.height += balloon.getPointerLength();
            return new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, balloon.getArc(), balloon.getArc());
        }
    }

    public static abstract class Position {
        abstract EmptyBorder createBorder(BalloonImpl var1);

        public void updateLocation(BalloonImpl balloon) {
            Rectangle bounds = balloon.myForcedBounds;
            if (bounds == null) {
                Dimension size = balloon.myComp.getPreferredSize();
                balloon.myComp.setSize(size);
                Dimension layeredPaneSize = balloon.myLayeredPane.getSize();
                Point location = balloon.myShowPointer ? this.getLocation(layeredPaneSize, balloon.myTargetPoint, size) : new Point(((BalloonImpl)balloon).myTargetPoint.x - size.width / 2, ((BalloonImpl)balloon).myTargetPoint.y - size.height / 2);
                bounds = new Rectangle(location.x, location.y, size.width, size.height);
                ScreenUtil.moveToFit((Rectangle)bounds, (Rectangle)new Rectangle(0, 0, layeredPaneSize.width, layeredPaneSize.height), (Insets)balloon.myContainerInsets);
            }
            balloon.myComp.setBounds(bounds);
        }

        abstract Point getLocation(Dimension var1, Point var2, Dimension var3);

        void paintComponent(BalloonImpl balloon, Rectangle bounds, Graphics2D g, Point pointTarget) {
            GraphicsConfig cfg = new GraphicsConfig((Graphics)g);
            cfg.setAntialiasing(true);
            Shape shape = balloon.myShowPointer ? this.getPointingShape(bounds, g, pointTarget, balloon) : new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, balloon.getArc(), balloon.getArc());
            g.setColor(balloon.myFillColor);
            g.fill(shape);
            g.setColor(balloon.myBorderColor);
            g.draw(shape);
            cfg.restore();
        }

        protected abstract Shape getPointingShape(Rectangle var1, Graphics2D var2, Point var3, BalloonImpl var4);
    }
}

