/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.tools.ToolManager;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import javax.swing.Icon;

public class ToolKeymapExtension
implements KeymapExtension {
    private static final Icon TOOLS_ICON = IconLoader.getIcon((String)"/nodes/keymapTools.png");
    private static final Icon TOOLS_OPEN_ICON = IconLoader.getIcon((String)"/nodes/keymapToolsOpen.png");

    public KeymapGroup createGroup(Condition<AnAction> filtered, Project project) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object[] ids = actionManager.getActionIds("Tool_");
        Arrays.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"actions.tree.external.tools.group", (Object[])new Object[0]), TOOLS_ICON, TOOLS_OPEN_ICON);
        ToolManager toolManager = ToolManager.getInstance();
        HashMap toolGroupNameToGroup = new HashMap();
        for (Object id : ids) {
            Group subGroup;
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub((String)id))) continue;
            String groupName = toolManager.getGroupByActionId((String)id);
            if (groupName != null && groupName.trim().length() == 0) {
                groupName = null;
            }
            if ((subGroup = (Group)toolGroupNameToGroup.get((Object)groupName)) == null) {
                subGroup = new Group(groupName, null, null);
                toolGroupNameToGroup.put((Object)groupName, (Object)subGroup);
                if (groupName != null) {
                    group.addGroup(subGroup);
                }
            }
            subGroup.addActionId((String)id);
        }
        Group subGroup = (Group)toolGroupNameToGroup.get(null);
        if (subGroup != null) {
            group.addAll(subGroup);
        }
        return group;
    }
}

