/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFrameworkDescriptor;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class TestIntegrationUtils {
    private static final Logger LOG = Logger.getInstance((String)("#" + TestIntegrationUtils.class.getName()));

    public static boolean isTest(PsiElement element) {
        PsiClass klass = TestIntegrationUtils.findOuterClass(element);
        return klass != null && TestUtil.isTestClass((PsiClass)klass);
    }

    public static PsiClass findOuterClass(PsiElement element) {
        PsiClass result = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (result == null) {
            return null;
        }
        PsiClass nextParent;
        while ((nextParent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)result, PsiClass.class, (boolean)true)) != null) {
            result = nextParent;
        }
        return result;
    }

    public static List<MemberInfo> extractClassMethods(PsiClass clazz, boolean includeInherited) {
        ArrayList<MemberInfo> result = new ArrayList<MemberInfo>();
        do {
            MemberInfo.extractClassMembers(clazz, result, new MemberInfoBase.Filter<PsiMember>(){

                public boolean includeMember(PsiMember member) {
                    if (!(member instanceof PsiMethod)) {
                        return false;
                    }
                    PsiModifierList list = member.getModifierList();
                    return list.hasModifierProperty("public");
                }
            }, false);
        } while ((clazz = clazz.getSuperClass()) != null && clazz.getSuperClass() != null && includeInherited);
        return result;
    }

    public static PsiMethod createMethod(PsiClass targetClass, String name, String annotation) throws IncorrectOperationException {
        PsiElementFactory f = JavaPsiFacade.getInstance((Project)targetClass.getProject()).getElementFactory();
        PsiMethod result = f.createMethod(name, PsiType.VOID);
        result.getBody().add((PsiElement)f.createCommentFromText("// Add your code here", (PsiElement)result));
        if (annotation != null) {
            PsiAnnotation a = f.createAnnotationFromText("@" + annotation, (PsiElement)result);
            PsiModifierList modifiers = result.getModifierList();
            PsiElement first = modifiers.getFirstChild();
            if (first == null) {
                modifiers.add((PsiElement)a);
            } else {
                modifiers.addBefore((PsiElement)a, first);
            }
            JavaCodeStyleManager.getInstance((Project)targetClass.getProject()).shortenClassReferences((PsiElement)modifiers);
        }
        return result;
    }

    public static void runTestMethodTemplate(MethodKind methodKind, TestFrameworkDescriptor descriptor, final Editor editor, PsiClass targetClass, PsiMethod method, String name, boolean automatic) {
        Template template = TestIntegrationUtils.createTestMethodTemplate(methodKind, descriptor, targetClass, name, automatic);
        final TextRange range = method.getTextRange();
        editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        final Project project = targetClass.getProject();
        TemplateEditingAdapter adapter = null;
        if (!automatic) {
            adapter = new TemplateEditingAdapter(){

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                            PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                            PsiElement method = psi.findElementAt(range.getStartOffset());
                            if (method != null && (method = PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, (boolean)false)) != null) {
                                CreateFromUsageUtils.setupEditor((PsiMethod)method, editor);
                            }
                        }
                    });
                }
            };
        }
        TemplateManager.getInstance(project).startTemplate(editor, template, adapter);
        PsiDocumentManager.getInstance((Project)targetClass.getProject()).commitDocument(editor.getDocument());
    }

    private static Template createTestMethodTemplate(MethodKind methodKind, TestFrameworkDescriptor descriptor, PsiClass targetClass, String name, boolean automatic) {
        int index;
        String templateText;
        FileTemplateDescriptor templateDesc = methodKind.getFileTemplateDescriptor(descriptor);
        String templateName = templateDesc.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance().getCodeTemplate(templateName);
        Template template = TemplateManager.getInstance(targetClass.getProject()).createTemplate("", "");
        try {
            templateText = fileTemplate.getText(new Properties());
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            templateText = fileTemplate.getText();
        }
        int from = 0;
        while ((index = templateText.indexOf("${NAME}", from)) != -1) {
            template.addTextSegment(templateText.substring(from, index));
            name = index > 0 && !Character.isWhitespace(templateText.charAt(index - 1)) ? StringUtil.capitalize((String)name) : StringUtil.decapitalize((String)name);
            if (from == 0) {
                ConstantNode nameExpr = new ConstantNode(name);
                template.addVariable("name", nameExpr, nameExpr, !automatic);
            } else {
                template.addVariableSegment("name");
            }
            from = index + "${NAME}".length();
        }
        template.addTextSegment(templateText.substring(from, templateText.length()));
        return template;
    }

    public static PsiMethod createDummyMethod(Project project) {
        PsiElementFactory f = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        return f.createMethod("dummy", PsiType.VOID);
    }

    public static enum MethodKind {
        SET_UP{

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(TestFrameworkDescriptor frameworkDescriptor) {
                return frameworkDescriptor.getSetUpMethodFileTemplateDescriptor();
            }
        }
        ,
        TEAR_DOWN{

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(TestFrameworkDescriptor frameworkDescriptor) {
                return frameworkDescriptor.getTearDownMethodFileTemplateDescriptor();
            }
        }
        ,
        TEST{

            @Override
            public FileTemplateDescriptor getFileTemplateDescriptor(TestFrameworkDescriptor frameworkDescriptor) {
                return frameworkDescriptor.getTestMethodFileTemplateDescriptor();
            }
        };


        public abstract FileTemplateDescriptor getFileTemplateDescriptor(TestFrameworkDescriptor var1);
    }
}

