/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.EmptyModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.HeavyTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.LightIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.LightTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class IdeaTestFixtureFactoryImpl
extends IdeaTestFixtureFactory {
    protected final Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> myFixtureBuilderProviders = new HashMap<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>>();
    private static final LightProjectDescriptor ourEmptyProjectDescriptor = new LightProjectDescriptor(){

        @Override
        public ModuleType getModuleType() {
            return EmptyModuleType.getInstance();
        }

        @Override
        public Sdk getSdk() {
            return null;
        }

        @Override
        public void configureModule(Module module, ModifiableRootModel model, ContentEntry contentEntry) {
        }
    };

    public IdeaTestFixtureFactoryImpl() {
        this.registerFixtureBuilder(EmptyModuleFixtureBuilder.class, MyEmptyModuleFixtureBuilderImpl.class);
    }

    @Override
    public final <T extends ModuleFixtureBuilder> void registerFixtureBuilder(Class<T> aClass, Class<? extends T> implClass) {
        this.myFixtureBuilderProviders.put(aClass, implClass);
    }

    @Override
    public void registerFixtureBuilder(Class<? extends ModuleFixtureBuilder> aClass, String implClassName) {
        try {
            Class<?> implClass = Class.forName(implClassName);
            assert (aClass.isAssignableFrom(implClass));
            this.registerFixtureBuilder(aClass, implClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instantiate fixture builder implementation", e);
        }
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder() {
        return new HeavyTestFixtureBuilderImpl(new HeavyIdeaTestFixtureImpl(), this.myFixtureBuilderProviders);
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder() {
        return new LightTestFixtureBuilderImpl<IdeaProjectTestFixture>(new LightIdeaTestFixtureImpl(ourEmptyProjectDescriptor));
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@Nullable LightProjectDescriptor projectDescriptor) {
        if (projectDescriptor == null) {
            projectDescriptor = ourEmptyProjectDescriptor;
        }
        return new LightTestFixtureBuilderImpl<IdeaProjectTestFixture>(new LightIdeaTestFixtureImpl(projectDescriptor));
    }

    @Override
    public CodeInsightTestFixture createCodeInsightFixture(IdeaProjectTestFixture projectFixture) {
        return this.createCodeInsightFixture(projectFixture, new TempDirTestFixtureImpl());
    }

    @Override
    public CodeInsightTestFixture createCodeInsightFixture(IdeaProjectTestFixture projectFixture, TempDirTestFixture tempDirFixture) {
        return new CodeInsightTestFixtureImpl(projectFixture, tempDirFixture);
    }

    @Override
    public TempDirTestFixture createTempDirTestFixture() {
        return new TempDirTestFixtureImpl();
    }

    public static class MyEmptyModuleFixtureBuilderImpl
    extends EmptyModuleFixtureBuilderImpl {
        public MyEmptyModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> testFixtureBuilder) {
            super(testFixtureBuilder);
        }

        @Override
        protected ModuleFixture instantiateFixture() {
            return new ModuleFixtureImpl(this);
        }
    }
}

