/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import gnu.trove.THashSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements HeavyIdeaTestFixture {
    @NonNls
    private static final String PROJECT_FILE_PREFIX = "temp";
    @NonNls
    private static final String PROJECT_FILE_SUFFIX = ".ipr";
    private Project myProject;
    private final Set<File> myFilesToDelete = new HashSet<File>();
    private IdeaTestApplication myApplication;
    private final Set<ModuleFixtureBuilder> myModuleFixtureBuilders = new THashSet();
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;

    HeavyIdeaTestFixtureImpl() {
    }

    protected void addModuleFixtureBuilder(ModuleFixtureBuilder builder) {
        this.myModuleFixtureBuilders.add(builder);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        this.setUpProject();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
    }

    @Override
    public void tearDown() throws Exception {
        LightPlatformTestCase.doTearDown(this.getProject(), this.myApplication, false);
        for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
            moduleFixtureBuilder.getFixture().tearDown();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Disposer.dispose((Disposable)HeavyIdeaTestFixtureImpl.this.myProject);
                    }
                });
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
        for (File fileToDelete : this.myFilesToDelete) {
            boolean deleted = FileUtil.delete((File)fileToDelete);
            assert (deleted) : "Can't delete " + fileToDelete;
        }
        super.tearDown();
        this.myEditorListenerTracker.checkListenersLeak();
        this.myThreadTracker.checkLeak();
        LightPlatformTestCase.checkEditorsReleased();
    }

    private void setUpProject() throws Exception {
        File projectFile = File.createTempFile(PROJECT_FILE_PREFIX, PROJECT_FILE_SUFFIX);
        this.myFilesToDelete.add(projectFile);
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
        this.myProject = PlatformTestCase.createProject(projectFile, buffer.toString());
        for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
            moduleFixtureBuilder.getFixture().setUp();
        }
        StartupManagerImpl sm = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        sm.runStartupActivities();
        sm.runPostStartupActivities();
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(this.myProject);
    }

    private void initApplication() throws Exception {
        this.myApplication = IdeaTestApplication.getInstance(null);
        this.myApplication.setDataProvider(new MyDataProvider());
    }

    @Override
    public Project getProject() {
        assert (this.myProject != null) : "setUp() should be called first";
        return this.myProject;
    }

    @Override
    public Module getModule() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        return modules.length == 0 ? null : modules[0];
    }

    @Override
    public PsiFile addFileToProject(@NonNls String rootPath, final @NonNls String relativePath, final @NonNls String fileText) throws IOException {
        final VirtualFile dir = VfsUtil.createDirectories((String)(rootPath + "/" + PathUtil.getParentPath((String)relativePath)));
        final VirtualFile[] virtualFile = new VirtualFile[1];
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                virtualFile[0] = dir.createChildData((Object)this, StringUtil.getShortName((String)relativePath, (char)'/'));
                VfsUtil.saveText((VirtualFile)virtualFile[0], (String)fileText);
            }
        }.execute();
        return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile[0]);
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.PROJECT.is(dataId)) {
                return HeavyIdeaTestFixtureImpl.this.myProject;
            }
            if (PlatformDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return FileEditorManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getSelectedTextEditor();
            }
            return null;
        }
    }
}

