/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.editorActions.SelectWordHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(List<IntentionAction> actions, @NonNls String text) {
        for (IntentionAction action : actions) {
            String s = action.getText();
            if (!s.equals(text)) continue;
            return action;
        }
        return null;
    }

    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file, @NonNls String actionText) throws Throwable {
        CodeInsightTestUtil.doIntentionTest(fixture, actionText, file + ".xml", file + "_after.xml");
    }

    public static void doIntentionTest(final @NotNull CodeInsightTestFixture fixture, @NonNls String action, @NotNull String before, @NotNull String after) throws Exception {
        if (fixture == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doIntentionTest must not be null");
        }
        if (before == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doIntentionTest must not be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doIntentionTest must not be null");
        }
        fixture.configureByFile(before);
        final IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(fixture.getAvailableIntentions(), action);
        assert (intentionAction != null) : "Action not found: " + action;
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                fixture.launchAction(intentionAction);
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, String ... after) throws Exception {
        if (fixture == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doWordSelectionTest must not be null");
        }
        if (before == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doWordSelectionTest must not be null");
        }
        assert (after != null && after.length > 0);
        fixture.configureByFile(before);
        SelectWordHandler action = new SelectWordHandler(null);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)fixture.getEditor().getComponent());
        for (String file : after) {
            action.execute(fixture.getEditor(), dataContext);
            fixture.checkResultByFile(file, false);
        }
    }

    public static void doSurroundWithTest(final @NotNull CodeInsightTestFixture fixture, final @NotNull Surrounder surrounder, @NotNull String before, @NotNull String after) throws Exception {
        if (fixture == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doSurroundWithTest must not be null");
        }
        if (surrounder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doSurroundWithTest must not be null");
        }
        if (before == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doSurroundWithTest must not be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doSurroundWithTest must not be null");
        }
        fixture.configureByFile(before);
        new WriteCommandAction.Simple(fixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                SurroundWithHandler.invoke(fixture.getProject(), fixture.getEditor(), fixture.getFile(), surrounder);
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doLiveTemplateTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) throws Exception {
        if (fixture == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doLiveTemplateTest must not be null");
        }
        if (before == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doLiveTemplateTest must not be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doLiveTemplateTest must not be null");
        }
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                new ListTemplatesAction().actionPerformedImpl(fixture.getProject(), fixture.getEditor());
                LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(fixture.getEditor());
                assert (lookup != null);
                lookup.finishLookup('\n');
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doSmartEnterTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) throws Exception {
        if (fixture == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doSmartEnterTest must not be null");
        }
        if (before == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doSmartEnterTest must not be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doSmartEnterTest must not be null");
        }
        fixture.configureByFile(before);
        final List processors = SmartEnterProcessors.INSTANCE.forKey((Object)fixture.getFile().getLanguage());
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                Editor editor = fixture.getEditor();
                for (SmartEnterProcessor processor : processors) {
                    processor.process(this.getProject(), editor, fixture.getFile());
                }
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doFormattingTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) throws Exception {
        if (fixture == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doFormattingTest must not be null");
        }
        if (before == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doFormattingTest must not be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/fixtures/CodeInsightTestUtil.doFormattingTest must not be null");
        }
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                CodeStyleManager.getInstance((Project)fixture.getProject()).reformat((PsiElement)fixture.getFile());
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }
}

