/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRenderer;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceNode
extends AbstractTreeNode<SliceUsage>
implements DuplicateNodeRenderer.DuplicatableNode<SliceNode>,
MyColoredTreeCellRenderer {
    protected List<SliceNode> myCachedChildren;
    protected boolean dupNodeCalculated;
    protected SliceNode duplicate;
    protected final DuplicateMap targetEqualUsages;
    protected boolean changed;
    private int index;

    protected SliceNode(@NotNull Project project, SliceUsage sliceUsage, @NotNull DuplicateMap targetEqualUsages) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceNode.<init> must not be null");
        }
        if (targetEqualUsages == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceNode.<init> must not be null");
        }
        super(project, (Object)sliceUsage);
        this.targetEqualUsages = targetEqualUsages;
    }

    SliceNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceNode newNode = new SliceNode(this.getProject(), newUsage, this.targetEqualUsages);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        return newNode;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ProgressIndicator indicator;
        ProgressIndicator current = ProgressManager.getInstance().getProgressIndicator();
        ProgressIndicator progressIndicator = indicator = current == null ? new ProgressIndicatorBase() : current;
        if (current == null) {
            indicator.start();
        }
        final Collection[] nodes = new Collection[1];
        ((ProgressManagerImpl)ProgressManager.getInstance()).executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                nodes[0] = SliceNode.this.getChildrenUnderProgress(ProgressManager.getInstance().getProgressIndicator());
            }
        }, indicator);
        if (current == null) {
            indicator.stop();
        }
        Collection collection = nodes[0];
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNode.getChildren must not return null");
        }
        return collection;
    }

    SliceNode getNext(List parentChildren) {
        return this.index == parentChildren.size() - 1 ? null : (SliceNode)parentChildren.get(this.index + 1);
    }

    SliceNode getPrev(List parentChildren) {
        return this.index == 0 ? null : (SliceNode)parentChildren.get(this.index - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends AbstractTreeNode> getChildrenUnderProgress(ProgressIndicator progress) {
        if (this.isUpToDate()) {
            return this.myCachedChildren == null ? Collections.emptyList() : this.myCachedChildren;
        }
        final ArrayList<SliceNode> children = new ArrayList<SliceNode>();
        final SliceManager manager = SliceManager.getInstance(this.getProject());
        manager.runInterruptibly(new Runnable(){

            @Override
            public void run() {
                Processor<SliceUsage> processor = new Processor<SliceUsage>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean process(SliceUsage sliceUsage) {
                        manager.checkCanceled();
                        SliceNode node = new SliceNode(SliceNode.this.myProject, sliceUsage, SliceNode.this.targetEqualUsages);
                        List list = children;
                        synchronized (list) {
                            node.index = children.size();
                            children.add(node);
                        }
                        return true;
                    }
                };
                ((SliceUsage)((Object)SliceNode.this.getValue())).processChildren(processor);
            }
        }, new Runnable(){

            @Override
            public void run() {
                SliceNode.this.changed = true;
            }
        }, progress);
        ArrayList<SliceNode> arrayList = children;
        synchronized (arrayList) {
            this.myCachedChildren = children;
        }
        return children;
    }

    private boolean isUpToDate() {
        return this.myCachedChildren != null || !this.isValid();
    }

    @NotNull
    protected PresentationData createPresentation() {
        PresentationData presentationData = new PresentationData(){

            public Object[] getEqualityObjects() {
                return ArrayUtil.append((Object[])super.getEqualityObjects(), (Object)SliceNode.this.changed);
            }
        };
        if (presentationData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNode.createPresentation must not return null");
        }
        return presentationData;
    }

    protected void update(PresentationData presentation) {
        if (presentation != null) {
            if (this.duplicate != null) {
                presentation.setTooltip("Duplicate node");
            }
            presentation.setChanged(presentation.isChanged() || this.changed);
            this.changed = false;
        }
    }

    public void calculateDupNode() {
        if (!this.dupNodeCalculated) {
            if (!(this.getValue() instanceof SliceTooComplexDFAUsage)) {
                this.duplicate = this.targetEqualUsages.putNodeCheckDupe(this);
            }
            this.dupNodeCalculated = true;
        }
    }

    @Override
    public SliceNode getDuplicate() {
        return this.duplicate;
    }

    public void navigate(boolean requestFocus) {
        SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
        sliceUsage.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((SliceUsage)((Object)this.getValue())).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((SliceUsage)((Object)this.getValue())).canNavigateToSource();
    }

    public boolean isValid() {
        return ((SliceUsage)((Object)this.getValue())).isValid();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Override
    public void customizeCellRenderer(SliceUsageCellRenderer renderer, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.setIcon(this.getPresentation().getIcon(expanded));
        if (this.isValid()) {
            SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
            renderer.customizeCellRendererFor(sliceUsage);
            renderer.setToolTipText(sliceUsage.getPresentation().getTooltipText());
        } else {
            renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRenderer.ourInvalidAttributes);
        }
    }

    public void setChanged() {
        this.changed = true;
    }

    public String toString() {
        return this.getValue() == null ? "<null>" : ((SliceUsage)((Object)this.getValue())).toString();
    }
}

