/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceTreeBuilder;

public class CanItBeNullAction
extends AnAction {
    private final SliceTreeBuilder myTreeBuilder;
    private static final String TEXT = "Can it be null?";

    public CanItBeNullAction(SliceTreeBuilder treeBuilder) {
        super(TEXT, "Determine whether null can flow into this expression", IconLoader.getIcon((String)"/debugger/db_disabled_breakpoint_process.png"));
        this.myTreeBuilder = treeBuilder;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setText(TEXT + (this.myTreeBuilder.analysisInProgress ? " (Analysis in progress)" : ""));
        e.getPresentation().setEnabled(this.isAvailable());
    }

    private boolean isAvailable() {
        PsiElement element;
        if (this.myTreeBuilder.analysisInProgress) {
            return false;
        }
        if (!this.myTreeBuilder.dataFlowToThis) {
            return false;
        }
        if (this.myTreeBuilder.splitByLeafExpressions) {
            return false;
        }
        SliceRootNode rootNode = (SliceRootNode)this.myTreeBuilder.getRootNode().getUserObject();
        PsiElement psiElement = element = rootNode == null ? null : rootNode.getRootUsage().getUsageInfo().getElement();
        Object type = element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiExpression ? ((PsiExpression)element).getType() : null);
        return type instanceof PsiClassType || type instanceof PsiArrayType;
    }

    public void actionPerformed(AnActionEvent e) {
        this.myTreeBuilder.switchToLeafNulls();
    }
}

